import {createDrawerNavigator} from '@react-navigation/drawer';
import R from '../../assets/R';
import {useEffect, useState} from 'react';
import styles from './style';
import {DeviceEventEmitter, Image, TouchableOpacity, View} from 'react-native';
import * as ScreenName from '../ScreenNames';
import SendEmail from '../../screens/email/send';
import DeleteEmail from '../../screens/email/delete';
import EmailHome from '../../screens/email';
import CustomDrawerMailContent from './itemDrawer';
import {connect} from 'react-redux';

const Drawer = createDrawerNavigator();
const IconMenu = R.images.icMenu;

const DrawerNavigatorEmailView = props => {
  const [reload, setReload] = useState(false);

  const HeaderBackButton = ({onPress, canGoBack}) => (
    <TouchableOpacity style={styles.sizeBox} onPress={onPress}>
      <Image source={R.images.icBack} style={styles.image} resizeMode="contain" />
    </TouchableOpacity>
  );

  const HeaderTitle = ({navigation, route}) => {
    <View style={styles.headerTitleContainer}>
      <MenuButton onPress={() => navigation.toggleDrawer()} />
      <View style={styles.avatar}></View>
    </View>;
  };

  useEffect(() => {
    const setLanguageListener = DeviceEventEmitter.addListener(
      'setLanguage',
      value => {
        setReload(prev => !prev);
      },
    );

    return () => {
      setLanguageListener.remove();
    };
  }, []);

  const MenuButton = ({onPress}) => (
    <TouchableOpacity
      style={[styles.sizeBox, {marginLeft: 10}]}
      onPress={onPress}>
      <Image
        source={IconMenu}
        style={styles.iconMenu}
        resizeMode="contain"
        tintColor={R.colors.gray2}
      />
    </TouchableOpacity>
  );

  return (
    <Drawer.Navigator
      drawerContent={drawerProps => (
        <CustomDrawerMailContent {...drawerProps} />
      )}
      initialRouteName={ScreenName.EMAIL}
      screenOptions={({navigation, route}) => ({
        header: () => (
          <View style={styles.headerTitleContainer}>
            <View>
              <HeaderBackButton
                onPress={() => {
                  if (navigation.canGoBack()) {
                    navigation.pop();
                  } else {
                    navigation.toggleDrawer();
                  }
                }}
                canGoBack={navigation.canGoBack()}
              />
            </View>
            <View style={styles.headerRight}>
              <MenuButton onPress={() => navigation.toggleDrawer()} />
              <View style={styles.avatar}></View>
            </View>
          </View>
        ),
        headerStyle: {
          backgroundColor: R.colors.blue,
        },
      })}>
      <Drawer.Screen
        name={ScreenName.EMAIL}
        component={EmailHome}
        options={{
          drawerLabel: () => null,
          drawerIcon: () => null,
          drawerItemStyle: {height: 0},
        }}
      />
      <Drawer.Screen
        name={ScreenName.SENDEDEMAIL}
        component={SendEmail}
        options={{
          drawerLabel: () => null,
          drawerIcon: () => null,
          drawerItemStyle: {height: 0},
        }}
      />
      <Drawer.Screen
        name={ScreenName.TRASHEMAIL}
        component={DeleteEmail}
        options={{
          drawerLabel: () => null,
          drawerIcon: () => null,
          drawerItemStyle: {height: 0},
        }}
      />
    </Drawer.Navigator>
  );
};

const mapStateToProps = state => ({
  user: state.userReducer,
});
export default connect(mapStateToProps, {})(DrawerNavigatorEmailView);
