import React from 'react';
import {
  Modal,
  View,
  Text,
  TouchableOpacity,
  ScrollView,
  Image,
  FlatList,
} from 'react-native';
import R from '../../../assets/R';
import styles from './style';
import TextField from '../../../components/Input/TextField';
import TextMulti from '../../../components/Input/TextMulti';
import Dropdown from '../../../components/DropdownAlert/Dropdown';
import Button from '../../../components/Button';

const AddWorkModalView = props => {
  const {
    visible,
    formData,
    dataList,
    categoryData,
    items,
    responsibleData,
    assigneeData,
    implementerData,
    updateFormData,
    handleSave,
    handleCancel,
    handleItemPress,
    handleDropdownSelect,
  } = props;
  const renderItem_1 = ({item, onPress}) => {
    return (
      <View style={styles.chip}>
        <TouchableOpacity
          style={styles.containerIcon}
          onPress={() => handleItemPress(item)}>
          <Image
            resizeMode="cover"
            source={R.images.icCancel}
            style={styles.imageIcon}
            tintColor={R.colors.blue}
          />
        </TouchableOpacity>
        <Text style={styles.textChip}> {`${item.id}, ${item.name}`}</Text>
      </View>
    );
  };
  return (
    <Modal
      visible={visible}
      animationType="slide"
      transparent={true}
      onRequestClose={handleCancel}>
      <View style={styles.overlay}>
        <View style={styles.modalContainer}>
          <ScrollView showsVerticalScrollIndicator={false}>
            <View style={styles.header}>
              <Text style={styles.headerTitle}>Thêm công việc</Text>
            </View>

            <View style={styles.formContainer}>
              <TextField
                title="Tiêu đề"
                required
                value={formData.title}
                onChangeText={value => updateFormData('title', value)}
                containerMarginBottom={10}
              />

              <TextMulti
                title="Mô tả"
                required
                value={formData.content}
                onChangeText={value => updateFormData('content', value)}
                containerMarginBottom={10}
                fontFamily={R.fonts.fontMedium}
                titleFontSize={R.fontsize.fontSizeContent}
              />

              <View style={styles.containerDropDown}>
                <Text
                  style={[
                    styles.text,
                    {
                      marginBottom: 3,
                      fontSize: R.fontsize.fontSizeLabel,
                      fontFamily: R.fonts.fontMedium,
                      fontWeight: '600',
                      color: R.colors.black,
                    },
                  ]}>
                  Thẻ
                </Text>
                <Dropdown
                  height={35}
                  items={items}
                  placeholder="Công việc theo văn bản"
                  onSelect={item => handleDropdownSelect(item, 'category')}
                />
              </View>
              <Text style={[styles.text_2, {marginBottom: 3}]}>
                Danh sách thẻ đã chọn
              </Text>
              <FlatList
                data={dataList}
                renderItem={({item}) => renderItem_1({item, onPress: () => {}})}
                keyExtractor={(item, index) =>
                  item.id?.toString() || index.toString()
                }
                numColumns={2}
                style={{maxHeight: 150, marginBottom: 10}}
                showsVerticalScrollIndicator={true}
                columnWrapperStyle={styles.flatListSelect}
                nestedScrollEnabled={true}
                scrollEnabled={true}
              />

              <View style={styles.containerDropDown}>
                <Text
                  style={[
                    styles.text,
                    {
                      marginBottom: 3,
                      fontSize: R.fontsize.fontSizeLabel,
                      fontFamily: R.fonts.fontMedium,
                      fontWeight: '600',
                      color: R.colors.black,
                    },
                  ]}>
                  Văn bản liên quan
                </Text>
                <Dropdown
                  height={35}
                  items={items}
                  placeholder="Công việc theo văn bản"
                  onSelect={item => handleDropdownSelect(item, 'document')}
                />
              </View>
              <Text style={[styles.text_2, {marginBottom: 3}]}>
                Danh sách văn bản đã chọn
              </Text>
              <FlatList
                data={dataList}
                renderItem={({item}) => renderItem_1({item, onPress: () => {}})}
                keyExtractor={(item, index) =>
                  item.id?.toString() || index.toString()
                }
                numColumns={2}
                style={{maxHeight: 150, marginBottom: 10}}
                showsVerticalScrollIndicator={true}
                columnWrapperStyle={styles.flatListSelect}
                nestedScrollEnabled={true}
                scrollEnabled={true}
              />

              <TextField
                title="Ngày đến hạn"
                required
                value={formData.deadline}
                onChangeText={value => updateFormData('deadline', value)}
                containerMarginBottom={10}
              />

              <View style={styles.containerDropDown}>
                <Text
                  style={[
                    styles.text,
                    {
                      marginBottom: 3,
                      fontSize: R.fontsize.fontSizeLabel,
                      fontFamily: R.fonts.fontMedium,
                      fontWeight: '600',
                      color: R.colors.black,
                    },
                  ]}>
                  Người theo dõi
                </Text>
                <Dropdown
                  height={35}
                  items={items}
                  onSelect={item => handleDropdownSelect(item, 'supervisor')}
                />
              </View>
              <Text style={[styles.text_2, {marginBottom: 3}]}>
                Danh sách người theo dõi đã chọn
              </Text>
              <FlatList
                data={dataList}
                renderItem={({item}) => renderItem_1({item, onPress: () => {}})}
                keyExtractor={(item, index) =>
                  item.id?.toString() || index.toString()
                }
                numColumns={2}
                style={{maxHeight: 150, marginBottom: 10}}
                showsVerticalScrollIndicator={true}
                columnWrapperStyle={styles.flatListSelect}
                nestedScrollEnabled={true}
                scrollEnabled={true}
              />

              <View style={styles.containerDropDown}>
                <Text
                  style={[
                    styles.text,
                    {
                      marginBottom: 3,
                      fontSize: R.fontsize.fontSizeLabel,
                      fontFamily: R.fonts.fontMedium,
                      fontWeight: '600',
                      color: R.colors.black,
                    },
                  ]}>
                  Người thực hiện công việc
                </Text>
                <Dropdown
                  height={35}
                  items={items}
                  onSelect={item => handleDropdownSelect(item, 'implementer')}
                />
              </View>
              <Text style={[styles.text_2, {marginBottom: 3}]}>
                Danh sách người thực hiện công việc
              </Text>
              <FlatList
                data={dataList}
                renderItem={({item}) => renderItem_1({item, onPress: () => {}})}
                keyExtractor={(item, index) =>
                  item.id?.toString() || index.toString()
                }
                numColumns={2}
                style={{maxHeight: 150, marginBottom: 10}}
                showsVerticalScrollIndicator={true}
                columnWrapperStyle={styles.flatListSelect}
                nestedScrollEnabled={true}
                scrollEnabled={true}
              />

              <View style={styles.buttonContainer}>
                <Button
                  title="Hủy"
                  textColor={R.colors.white}
                  onPress={handleCancel}
                  backgroundColor={R.colors.orange}
                  fontSize={R.sizes.sm}
                  fontFamily={R.fonts.fontMedium}
                  height={35}
                  width={100}
                  containerStyle={{paddingHorizontal: 15, borderRadius: 30}}
                />
                <Button
                  title="Thêm mới"
                  textColor={R.colors.white}
                  onPress={handleSave}
                  backgroundColor={R.colors.blue}
                  fontSize={R.sizes.sm}
                  fontFamily={R.fonts.fontMedium}
                  height={35}
                  width={100}
                  containerStyle={{borderRadius: 30}}
                />
              </View>
            </View>
          </ScrollView>
        </View>
      </View>
    </Modal>
  );
};

export default AddWorkModalView;
