import React, {useState, useMemo} from 'react';
import {useNavigation} from '@react-navigation/native';
import ListWorkView from './view';
import * as ScreenName from '../../routers/ScreenNames';
import {WORK_PROGRESS, ROLE} from '../../actions/actionTypes';
import R from '../../assets/R';

const ListWork = props => {
  const navigation = useNavigation();

  const [searchQuery, setSearchQuery] = useState('');
  const [currentTabKey, setCurrentTabKey] = useState(ROLE.ALL);
  const [currentDropDownKey, setCurrentDropDownKey] = useState(
    WORK_PROGRESS.ALL_WORK_PROGRESS,
  );

  const [modalDeliverToMeVisible, setModalDeliverToMeVisible] = useState(false);
  const [modalMonitoringVisible, setModalMonitoringVisible] = useState(false);
  const [modalRequestReportVisible, setModalRequestReportVisible] =
    useState(false);
  const [modalReportVisible, setmodalReportVisible] = useState(false);

  const [tabView, setTabView] = useState([
    {key: ROLE.ALL, label: 'Tất cả'},
    {key: ROLE.ASSIGNEE, label: 'Giao cho tôi'},
    {key: ROLE.SUPERVISOR, label: 'Đang giám sát'},
  ]);

  const [dataList, setDataList] = useState([
    {
      id: 1,
      title: 'Tạo thời khóa biểu cho sinh viên khai giảng và học kỳ 2 năm 2025',
      status: 'Đang thực hiện',
      deadline: '2025-09-04',
      assignedToMe: true,
      supervisedByMe: false,
      supervisor: [
        {id: 1, name: 'Trần Văn Hùng'},
        {id: 2, name: 'Nguyễn Văn A'},
      ],
      document: 'BM255, Nguyễn Minh Đức',
      workProgress: 'Đang thực hiện',
    },
    {
      id: 2,
      title: 'Tạo thời khóa biểu cho sinh viên khai giảng và học kỳ 2 năm 2025',
      status: 'Cần chỉnh sửa',
      deadline: '2025-09-04',
      assignedToMe: true,
      supervisedByMe: false,
      supervisor: [
        {id: 1, name: 'Trần Văn Hùng'},
        {id: 2, name: 'Nguyễn Văn A'},
      ],
      document: 'BM255, Nguyễn Minh Đức',
      workProgress: 'Đang hoàn thành',
    },
    {
      id: 3,
      title: 'Tạo thời khóa biểu cho sinh viên khai giảng và học kỳ 2 năm 2025',
      status: 'Hoàn thành',
      deadline: '2025-09-04',
      assignedToMe: true,
      supervisedByMe: false,
      supervisor: [
        {id: 1, name: 'Trần Văn Hùng'},
        {id: 2, name: 'Nguyễn Văn A'},
      ],
      document: 'BM255, Nguyễn Minh Đức',
      workProgress: 'Đang hoàn thành',
    },
    {
      id: 4,
      title: 'Tạo thời khóa biểu cho sinh viên khai giảng và học kỳ 2 năm 2025',
      status: 'Đợi báo cáo',
      deadline: '2025-09-04',
      assignedToMe: false,
      supervisedByMe: true,
      supervisor: [
        {id: 1, name: 'Trần Văn Hùng'},
        {id: 2, name: 'Nguyễn Văn A'},
      ],
      document: 'BM255, Nguyễn Minh Đức',
      workProgress: 'Đang hoàn thành',
    },
    {
      id: 5,
      title: 'Tạo thời khóa biểu cho sinh viên khai giảng và học kỳ 2 năm 2025',
      status: 'Hoàn thành',
      deadline: '2025-09-04',
      assignedToMe: false,
      supervisedByMe: true,
      supervisor: [
        {id: 1, name: 'Trần Văn Hùng'},
        {id: 2, name: 'Nguyễn Văn A'},
      ],
      document:
        'Văn bản thông báo lịch nộp thời khóa biểu của học kỳ 2 năm 2025',
      workProgress: 'Đang thực hiện',
    },
    {
      id: 6,
      title: 'Cập nhật đề cương môn CSDL nâng cao',
      status: 'Đang thực hiện',
      deadline: '2025-09-10',
      assignedToMe: true,
      supervisedByMe: false,
      supervisor: [
        {id: 1, name: 'Trần Văn Hùng'},
        {id: 2, name: 'Nguyễn Văn A'},
      ],
      document: 'BM301, Phòng Đào tạo',
      workProgress: 'Đang thực hiện',
    },
    {
      id: 7,
      title: 'Bổ sung tài liệu tham khảo môn Mạng máy tính',
      status: 'Cần chỉnh sửa',
      deadline: '2025-09-12',
      assignedToMe: true,
      supervisedByMe: false,
      supervisor: [
        {id: 1, name: 'Trần Văn Hùng'},
        {id: 2, name: 'Nguyễn Văn A'},
      ],
      document: 'Công văn 12/MN',
      workProgress: 'Đã hoàn thành',
    },
    {
      id: 8,
      title: 'Chuẩn bị lịch thi giữa kỳ Khoa CNTT',
      status: 'Đợi báo cáo',
      deadline: '2025-09-15',
      assignedToMe: true,
      supervisedByMe: false,
      supervisor: [
        {id: 1, name: 'Trần Văn Hùng'},
        {id: 2, name: 'Nguyễn Văn A'},
      ],
      document: 'BM-Exam-2025',
      workProgress: 'Đã hoàn thành',
    },
    {
      id: 9,
      title: 'Rà soát nội dung slide môn Lập trình di động',
      status: 'Chờ duyệt',
      deadline: '2025-09-11',
      assignedToMe: true,
      supervisedByMe: false,
      supervisor: [
        {id: 1, name: 'Trần Văn Hùng'},
        {id: 2, name: 'Nguyễn Văn A'},
      ],
      document: 'Slide_v2.pptx',
      workProgress: 'Đã hoàn thành',
    },
    {
      id: 10,
      title: 'Hoàn thiện đề cương môn AI ứng dụng',
      status: 'Hoàn thành',
      deadline: '2025-09-05',
      assignedToMe: true,
      supervisedByMe: false,
      supervisor: [
        {id: 1, name: 'Trần Văn Hùng'},
        {id: 2, name: 'Nguyễn Văn A'},
      ],
      document: 'AI-Syllabus-Final.pdf',
      workProgress: 'Đang thực hiện',
    },
    {
      id: 11,
      title: 'Theo dõi tiến độ cập nhật website khoa',
      status: 'Đang thực hiện',
      deadline: '2025-09-18',
      assignedToMe: false,
      supervisedByMe: true,
      supervisor: [
        {id: 1, name: 'Trần Văn Hùng'},
        {id: 2, name: 'Nguyễn Văn A'},
      ],
      document: 'Biên bản họp 09/2025',
      workProgress: 'Đang thực hiện',
    },
    {
      id: 12,
      title: 'Yêu cầu chỉnh sửa báo cáo đề tài nghiên cứu',
      status: 'Đợi chỉnh sửa',
      deadline: '2025-09-20',
      assignedToMe: false,
      supervisedByMe: true,
      supervisor: [
        {id: 1, name: 'Trần Văn Hùng'},
        {id: 2, name: 'Nguyễn Văn A'},
      ],
      document: 'Report-Draft.docx',
      workProgress: 'Đã hoàn thành',
    },
    {
      id: 13,
      title: 'Giám sát thu thập minh chứng kiểm định',
      status: 'Đợi báo cáo',
      deadline: '2025-09-22',
      assignedToMe: false,
      supervisedByMe: true,
      supervisor: [
        {id: 1, name: 'Trần Văn Hùng'},
        {id: 2, name: 'Nguyễn Văn A'},
      ],
      document: 'Checklist-KDCL.xlsx',
      workProgress: 'Đã hoàn thành',
    },
    {
      id: 14,
      title: 'Phê duyệt lịch seminar học kỳ 1',
      status: 'Chờ duyệt',
      deadline: '2025-09-13',
      assignedToMe: false,
      supervisedByMe: true,
      supervisor: [
        {id: 1, name: 'Trần Văn Hùng'},
        {id: 2, name: 'Nguyễn Văn A'},
      ],
      document: 'SeminarPlan.docx',
      workProgress: 'Đang thực hiện',
    },
    {
      id: 15,
      title: 'Nghiệm thu giáo trình Nhập môn CNTT',
      status: 'Hoàn thành',
      deadline: '2025-09-03',
      assignedToMe: false,
      supervisedByMe: true,
      supervisor: [
        {id: 1, name: 'Trần Văn Hùng'},
        {id: 2, name: 'Nguyễn Văn A'},
      ],
      document: 'Textbook-Final.pdf',
      workProgress: 'Đã hoàn thành',
    },
    {
      id: 16,
      title: 'Soạn đề bài lab React Native tuần 3',
      status: 'Đang thực hiện',
      deadline: '2025-09-16',
      assignedToMe: true,
      supervisedByMe: false,
      supervisor: [
        {id: 1, name: 'Trần Văn Hùng'},
        {id: 2, name: 'Nguyễn Văn A'},
      ],
      document: 'RN-Lab3.md',
      workProgress: 'Đang thực hiện',
    },
    {
      id: 17,
      title: 'Sửa lỗi bài tập lớn nhóm 2',
      status: 'Cần chỉnh sửa',
      deadline: '2025-09-17',
      assignedToMe: true,
      supervisedByMe: false,
      supervisor: [
        {id: 1, name: 'Trần Văn Hùng'},
        {id: 2, name: 'Nguyễn Văn A'},
      ],
      document: 'Issue#127',
      workProgress: 'Đang thực hiện',
    },
    {
      id: 18,
      title: 'Giám sát cập nhật slide môn Big Data',
      status: 'Đợi chỉnh sửa',
      deadline: '2025-09-19',
      assignedToMe: false,
      supervisedByMe: true,
      supervisor: [
        {id: 1, name: 'Trần Văn Hùng'},
        {id: 2, name: 'Nguyễn Văn A'},
      ],
      document: 'BigData-Slides-v1.pptx',
      workProgress: 'Đang thực hiện',
    },
    {
      id: 19,
      title: 'Hoàn thiện biên bản họp tổ bộ môn',
      status: 'Đợi báo cáo',
      deadline: '2025-09-14',
      assignedToMe: true,
      supervisedByMe: false,
      supervisor: [
        {id: 1, name: 'Trần Văn Hùng'},
        {id: 2, name: 'Nguyễn Văn A'},
      ],
      document: 'Minutes-Dept-0909.docx',
      workProgress: 'Đang thực hiện',
    },
    {
      id: 20,
      title: 'Xét duyệt danh sách đồ án tốt nghiệp',
      status: 'Chờ duyệt',
      deadline: '2025-09-21',
      assignedToMe: false,
      supervisedByMe: true,
      supervisor: [
        {id: 1, name: 'Trần Văn Hùng'},
        {id: 2, name: 'Nguyễn Văn A'},
      ],
      document: 'Thesis-List.xlsx',
      workProgress: 'Chờ duyệt',
    },
  ]);

  const handleAddWork = () => {
    if (currentTabKey === ROLE.ASSIGNEE) {
      setModalDeliverToMeVisible(true);
    } else if (currentTabKey === ROLE.SUPERVISOR) {
      setModalMonitoringVisible(true);
    }
  };

  const handleRequestReport = () => {
    setModalRequestReportVisible(true);
  };

  const handleReport = () => {
    setmodalReportVisible(true);
  };

  const handleCloseDeliverToMeModal = () => {
    setModalDeliverToMeVisible(false);
  };

  const handleCloseMonitoringModal = () => {
    setModalMonitoringVisible(false);
  };

  const handleSaveDeliverToMeWork = workData => {
    setModalDeliverToMeVisible(false);
  };

  const handleSaveMonitoringWork = workData => {
    setModalMonitoringVisible(false);
  };
  const handleFilterChange = item => {
    setCurrentTabKey(item?.key || ROLE.ALL);
  };

  const filterList = useMemo(() => {
    let base = dataList;

    if (currentTabKey === ROLE.ASSIGNEE) {
      base = base.filter(x => x.assignedToMe);
    } else if (currentTabKey === ROLE.SUPERVISOR) {
      base = base.filter(x => x.supervisedByMe);
    }

    if (searchQuery && searchQuery.trim()) {
      const q = searchQuery.trim().toLowerCase();
      base = base.filter(
        x =>
          x.title.toLowerCase().includes(q) ||
          x.status.toLowerCase().includes(q),
      );
    }

    if (currentDropDownKey === WORK_PROGRESS.SUCCESS_WORK_PROGRESS) {
      base = base.filter(x => x.status === 'Đã hoàn thành');
    } else if (currentDropDownKey === WORK_PROGRESS.CONTINUE_WORK_PROGRESS) {
      base = base.filter(x => x.status !== 'Đã hoàn thành');
    }

    return base;
  }, [dataList, currentTabKey, searchQuery, currentDropDownKey]);

  const handleViewDetailWork = item => {
    if (item.assignedToMe) {
      navigation.navigate(ScreenName.DETAILWORKDELIVERTOME, {workItem: item});
    } else if (item.supervisedByMe) {
      navigation.navigate(ScreenName.DETAILWORKMONITORING, {workItem: item});
    }
  };

  const handleViewDetailDeliverToMe = item => {
    handleViewDetailWork(item);
  };

  const handleReportAction = () => {
    setmodalReportVisible(true);
  };

  const handleApprovalAction = (item, action) => {
    console.log(`Thực hiện hành động ${action} cho công việc:`, item.id);
    switch (action) {
      case 'approve':
        break;
      case 'needsEdit':
        break;
      default:
        break;
    }
  };
  
  const getStatusColor = status => {
    switch (status) {
      case 'Đang thực hiện':
        return R.colors.orange;
      case 'Chờ duyệt':
        return R.colors.blue;
      case 'Cần chỉnh sửa':
        return R.colors.orange;
      case 'Đợi chỉnh sửa':
        return R.colors.orange;
      case 'Hoàn thành':
        return R.colors.green1;
      case 'Đợi báo cáo':
        return R.colors.blue;
      default:
        return R.colors.black;
    }
  };

  const getButtonsForStatus = (status, workItem) => {
    if (currentTabKey === ROLE.SUPERVISOR) {
      return getButtonsForSupervisor(status);
    }

    if (currentTabKey === ROLE.ASSIGNEE) {
      return getButtonsForAssignee(status);
    }

    if (currentTabKey === ROLE.ALL) {
      if (workItem.assignedToMe) {
        return getButtonsForAssignee(status);
      }
      if (workItem.supervisedByMe) {
        return getButtonsForSupervisor(status);
      }
    }

    return [
      {title: 'Chi tiết', backgroundColor: R.colors.blue, action: 'detail'},
    ];
  };

  const getButtonsForSupervisor = status => {
    switch (status) {
      case 'Đang thực hiện':
        return [
          {
            title: 'Yêu cầu báo cáo',
            backgroundColor: R.colors.orange,
            action: 'requestReport',
          },
          {title: 'Chi tiết', backgroundColor: R.colors.blue, action: 'detail'},
        ];
      case 'Đợi chỉnh sửa':
        return [
          {title: 'Chi tiết', backgroundColor: R.colors.blue, action: 'detail'},
        ];
      case 'Chờ duyệt':
        return [
          {
            title: 'Cần chỉnh sửa',
            backgroundColor: R.colors.orange,
            action: 'needsEdit',
          },
          {
            title: 'Phê duyệt',
            backgroundColor: R.colors.green,
            action: 'approve',
          },
          {title: 'Chi tiết', backgroundColor: R.colors.blue, action: 'detail'},
        ];
      case 'Đợi báo cáo':
        return [
          {title: 'Chi tiết', backgroundColor: R.colors.blue, action: 'detail'},
        ];
      case 'Hoàn thành':
        return [
          {title: 'Chi tiết', backgroundColor: R.colors.blue, action: 'detail'},
        ];
      default:
        return [];
    }
  };

  const getButtonsForAssignee = status => {
    switch (status) {
      case 'Đang thực hiện':
        return [
          {
            title: 'Báo cáo',
            backgroundColor: R.colors.orange,
            action: 'report',
          },
          {title: 'Chi tiết', backgroundColor: R.colors.blue, action: 'detail'},
        ];
      case 'Cần chỉnh sửa':
        return [
          {
            title: 'Báo cáo',
            backgroundColor: R.colors.orange,
            action: 'report',
          },
          {title: 'Chi tiết', backgroundColor: R.colors.blue, action: 'detail'},
        ];
      case 'Đợi báo cáo':
        return [
          {
            title: 'Báo cáo',
            backgroundColor: R.colors.orange,
            action: 'report',
          },
          {title: 'Chi tiết', backgroundColor: R.colors.blue, action: 'detail'},
        ];
      case 'Chờ duyệt':
        return [
          {
            title: 'Sửa báo cáo',
            backgroundColor: R.colors.orange,
            action: 'editReport',
          },
          {title: 'Chi tiết', backgroundColor: R.colors.blue, action: 'detail'},
        ];
      case 'Hoàn thành':
        return [
          {title: 'Chi tiết', backgroundColor: R.colors.blue, action: 'detail'},
        ];
      default:
        return [];
    }
  };

  const handleSubmitRequestReport = reportData => {
    setModalRequestReportVisible(false);
  };

  const handleSubmitReport = () => {
    setModalRequestReportVisible(false);
  };

  const handleCloseModalReport = () => {
    setmodalReportVisible(false);
  };

  const handleCloseModalRequestReport = () => {
    setModalRequestReportVisible(false);
  };

  const shouldShowFAB = () => {
    return currentTabKey !== ROLE.ALL;
  };

  return (
    <ListWorkView
      searchQuery={searchQuery}
      setSearchQuery={setSearchQuery}
      dataList={filterList}
      modalRequestReport={modalRequestReportVisible}
      modalDeliverToMeVisible={modalDeliverToMeVisible}
      modalMonitoringVisible={modalMonitoringVisible}
      modalReport={modalReportVisible}
      tabView={tabView}
      currentTabKey={currentTabKey}
      shouldShowFAB={shouldShowFAB()}
      onFilterChange={handleFilterChange}
      onAddWork={handleAddWork}
      onOpenModalRequestReport={handleRequestReport}
      onOpenModalReport={handleReport}
      onSaveDeliverToMeWork={handleSaveDeliverToMeWork}
      onSaveMonitoringWork={handleSaveMonitoringWork}
      onSaveSumbitRequestReport={handleSubmitRequestReport}
      onSaveSumbitReport={handleSubmitReport}
      onCloseDeliverToMeModal={handleCloseDeliverToMeModal}
      onCloseRequestReport={handleCloseModalRequestReport}
      onCloseModalReport={handleCloseModalReport}
      onCloseMonitoringModal={handleCloseMonitoringModal}
      onViewDetailDeliverToMe={handleViewDetailDeliverToMe}
      onReportAction={handleReportAction}
      onApprovalAction={handleApprovalAction}
      getStatusColor={getStatusColor}
      getButtonsForStatus={getButtonsForStatus}
    />
  );
};

export default ListWork;
