import {StyleSheet, Text, View} from 'react-native';
import R from '../../../assets/R';

const styles = StyleSheet.create({
  container: {
    flex: 1,
    backgroundColor: R.colors.white,
  },
  body: {
    flex: 1,
    backgroundColor: R.colors.white,
    marginHorizontal: 15,
  },
  text: {
    fontSize: R.fontsize.fontSizeContent,
    color: R.colors.black,
    fontWeight: '600',
    fontFamily: R.fonts.fontMedium,
  },
  sub_text: {
    fontSize: R.fontsize.fontSizeContent,
    color: R.colors.black,
    fontWeight: '400',
    fontFamily: R.fonts.fontRegular,
  },
  containerContent: {
    borderWidth: 1,
    borderRadius: 10,
    padding: 10,
    marginBottom: 5,
    borderColor: R.colors.grayBorderInputTextHeader,
  },
  containerFile: {
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'space-between',
    borderRadius: 10,
    backgroundColor: R.colors.blue1,
    marginBottom: 5,
    height: 30,
    paddingHorizontal: 10,
  },
  image: {
    width: 20,
    height: 20,
  },
  chip: {
    flexDirection: 'row',
    alignItems: 'center',
    // position: 'relative',
    paddingLeft: 10,
    paddingRight: 10,
    height: 25,
    borderRadius: 10,
    marginBottom: 10,
    marginRight: 5,
    backgroundColor: R.colors.blue2,
    alignSelf: 'flex-start',
  },
  containerIcon: {
    marginRight: 2,
  },
  imageIcon: {
    width: 15,
    height: 15,
  },
  textChip: {
    fontSize: R.fontsize.fontSizeContent,
    fontWeight: '400',
    fontFamily: R.fonts.fontRegular,
    color: R.colors.blueTextChip,
  },
  flatListSelect: {
    flexDirection: 'row',
    flexWrap: 'wrap',
  },
  containerDropdown: {
    marginBottom: 5,
  },
  containerCard: {
    borderRadius: 10,
    marginBottom: 10,
  },
});

export default styles;
