import {StyleSheet, Text, View} from 'react-native';
import R from '../../../assets/R';

const styles = StyleSheet.create({
  container: {
    flex: 1,
    backgroundColor: R.colors.white,
  },
  body: {
    flex: 1,
    backgroundColor: R.colors.white,
    padding: 15,
  },
  header: {
    flexDirection: 'row',
    backgroundColor: R.colors.blue,
    height: 50,
    alignItems: 'center',
    justifyContent: 'space-between',
    paddingHorizontal: 15,
  },
  icon: {
    width: 25,
    height: 20,
  },
  sendButton: {
    backgroundColor: R.colors.orange,
    borderRadius: 5,
    width: 90,
    paddingHorizontal: 5,
    height: 35,
    alignItems: 'center',
    justifyContent: 'space-around',
    flexDirection: 'row',
  },
  sendText: {
    color: R.colors.white,
    fontSize: R.fontsize.fontSizeSubTitle,
    fontFamily: R.fonts.fontRegular,
    fontWeight: '400',
  },
  iconSend: {
    width: 20,
    height: 20,
  },
  title: {
    fontSize: R.fontsize.fontSizeSubTitle,
    fontFamily: R.fonts.fontMedium,
    fontWeight: '600',
    color: R.colors.white,
  },
  iconClose: {
    width: 15,
    height: 15,
  },
  inputContainer: {
    flexDirection: 'row',
    borderBottomWidth: 1,
    borderColor: R.colors.grayBorderInputTextHeader,
    borderRadius: 5,
    height: 35,
    alignItems: 'center',
  },
  input: {
    flex: 1,
    padding: 0,
    paddingHorizontal: 10,
    paddingVertical: 0,
  },
});

export default styles;
