import React, {useEffect, useState} from 'react';
import {DeviceEventEmitter, Image, View} from 'react-native';
import {createBottomTabNavigator} from '@react-navigation/bottom-tabs';
import {useFocusEffect} from '@react-navigation/native';
import i18n from '../helper/i18/i18n';
import {connect} from 'react-redux';
import R from '../assets/R';
import Notification from '../screens/notification';
import Profile from '../screens/profile';
import ClassSchedule from '../screens/class_schedule';
import Home from '../screens/home';
import QrCode from '../screens/qr_code';
import DrawerNavigator from './drawer_schedule';

const Tab = createBottomTabNavigator();

const TabNavigator = props => {
  const [reload, setReload] = useState(false);
  const [hideTabBar, setHideTabBar] = useState(false);

  useEffect(() => {
    let setLanguage = DeviceEventEmitter.addListener('setLanguage', value => {
      setReload(!reload);
    });

    let hideTabs = DeviceEventEmitter.addListener('hideTabs', shouldHide => {
      setHideTabBar(shouldHide);
    });

    return () => {
      setLanguage.remove();
      hideTabs.remove();
    };
  }, []);

  return (
    <Tab.Navigator
      initialRouteName="Screen5"
      screenOptions={{
        headerShown: false,
        tabBarStyle: hideTabBar
          ? {display: 'none'}
          : {
              shadowColor: '#000',
              shadowOffset: {
                width: 0,
                height: 2,
              },
              shadowOpacity: 0.29,
              shadowRadius: 2,
              elevation: 7,
              justifyContent: 'center',
            },
      }}
      tabBarOptions={{
        showIcon: true,
        showLabel: true,
        activeTintColor: R.colors.main,
      }}>
      <Tab.Screen
        name="HomeScreen1"
        component={Home}
        options={{
          tabBarLabel: i18n.t('Home'),
          tabBarIcon: ({color, size}) => (
            <Image
              source={R.images.icHome}
              style={{width: size, height: size, tintColor: color}}
            />
          ),
        }}
      />
      <Tab.Screen
        name="HomeScreen145"
        component={DrawerNavigator}
        options={{
          tabBarLabel: i18n.t('Class_schedule'),
          tabBarIcon: ({color, size}) => (
            <Image
              source={R.images.icLichDay}
              style={{width: size, height: size, tintColor: color}}
            />
          ),
        }}
      />
      <Tab.Screen
        name="HomeScreen14"
        component={QrCode}
        options={{
          tabBarLabel: i18n.t('QrCode'),
          tabBarIcon: ({color, size}) => (
            <Image
              source={R.images.icQrCodeTab}
              style={{width: size, height: size, tintColor: color}}
            />
          ),
        }}
      />

      <Tab.Screen
        name="NotificationScreen"
        component={Notification}
        options={{
          tabBarLabel: 'Thông báo',
          tabBarIcon: ({color, size}) => (
            <Image
              source={R.images.icNotification}
              style={{width: size, height: size - 3, tintColor: color}}
              resizeMode={'contain'}
            />
          ),
        }}
      />

      <Tab.Screen
        name="ProfileScreen"
        component={Profile}
        options={{
          tabBarLabel: 'Hồ sơ',
          tabBarIcon: ({color, size}) => (
            <Image
              source={R.images.icProfile}
              style={{width: size, height: size - 3, tintColor: color}}
              resizeMode={'contain'}
            />
          ),
        }}
      />
    </Tab.Navigator>
  );
};

const mapStateToProps = state => {
  return {
    user: state.userReducer,
  };
};

export default connect(mapStateToProps, {})(TabNavigator);
