import React, {useState} from 'react';
import {Text, View, StyleSheet} from 'react-native';
import ProfileView from './view';

const Profile = props => {
  const [user, setUser] = useState({
    name: 'Phạm Minh Quân',
    role: 'Trợ lý bộ môn thuộc trường',
    code: '80578',
    email: 'quan.pm@uit.edu.vn',
    authCredential: 'quanpm',
    department: 'Khoa học máy tính',
    teachingUnit: 'Trí tuệ nhân tạo',
    workPlace: 'Trường Cao Đẳng FPT',
    extraDuty: 'Vị trí kiêm nhiệm',
    employmentType: ['Quyền trưởng phòng', 'Trợ lý bộ môn thuộc trường'],
    appointmentDecision: 'QĐ/UIT/2025',
    appointmentDate: '20/03/2025',
    allowanceSeniorityDate: '10/03/2025',
    teacherType: 'CBGV trường',
    academicUnit: 'Khoa Công nghệ phần mềm',
    subjectDepartment: 'Bộ môn Phát triển phần mềm',
    employmentStatus: 'Đang công tác',
    workCommencementDate: '20/03/2025',
  });

  // States cho các TextField trong form
  const [phoneNumber, setPhoneNumber] = useState('');
  const [oldTeacherCode, setOldTeacherCode] = useState('');
  const [workPlace, setWorkPlace] = useState('');
  const [position, setPosition] = useState('');
  const [extraDuty, setExtraDuty] = useState('');
  const [laborType, setLaborType] = useState('');
  const [employmentType, setEmploymentType] = useState('');
  const [appointmentDecision, setAppointmentDecision] = useState('');
  const [appointmentDate, setAppointmentDate] = useState('');
  const [issuingAgency, setIssuingAgency] = useState('');
  const [jobBeforeRecruitment, setJobBeforeRecruitment] = useState('');
  const [allowanceSeniorityDate, setAllowanceSeniorityDate] = useState('');
  const [workAllowancePercent, setWorkAllowancePercent] = useState('');
  const [teacherAllowancePercent, setTeacherAllowancePercent] = useState('');
  const [teacherType, setTeacherType] = useState('');
  const [academicUnit, setAcademicUnit] = useState('');
  const [subjectDepartment, setSubjectDepartment] = useState('');
  const [employmentStatus, setEmploymentStatus] = useState('');
  const [workStartDate, setWorkStartDate] = useState('');
  const [currentContractType, setCurrentContractType] = useState('');
  const [contractStartDate, setContractStartDate] = useState('');
  const [contractEndDate, setContractEndDate] = useState('');
  const [currentContractNumber, setCurrentContractNumber] = useState('');
  const [contractEffectiveDate, setContractEffectiveDate] = useState('');
  const [fullTimeWorkStartDate, setFullTimeWorkStartDate] = useState('');
  const [lastClassificationDate, setLastClassificationDate] = useState('');
  const [currentWorkAllowancePercent, setCurrentWorkAllowancePercent] = useState('');
  const [salaryGrade, setSalaryGrade] = useState('');
  const [currentSalaryLevel, setCurrentSalaryLevel] = useState('');
  const [currentSalaryCoefficient, setCurrentSalaryCoefficient] = useState('');
  const [salaryIncreaseMilestone, setSalaryIncreaseMilestone] = useState('');
  const [lecturerTitle, setLecturerTitle] = useState('');

  const [selectedValue2, setSelectedValue2] = useState('1');
  const options2 = [
    {label: 'Cơ chế', value: '1'},
    {label: 'Biên hữu', value: '2'},
  ];
  
  const onValueChange2 = value => {
    setSelectedValue2(value);
  };

  const handleSave = () => {
    const formData = {
      phoneNumber,
      oldTeacherCode,
      workPlace,
      position,
      extraDuty,
      laborType,
      employmentType,
      appointmentDecision,
      appointmentDate,
      issuingAgency,
      jobBeforeRecruitment,
      selectedValue2,
      allowanceSeniorityDate,
      workAllowancePercent,
      teacherAllowancePercent,
      teacherType,
      academicUnit,
      subjectDepartment,
      employmentStatus,
      workStartDate,
      currentContractType,
      contractStartDate,
      contractEndDate,
      currentContractNumber,
      contractEffectiveDate,
      fullTimeWorkStartDate,
      lastClassificationDate,
      currentWorkAllowancePercent,
      salaryGrade,
      currentSalaryLevel,
      currentSalaryCoefficient,
      salaryIncreaseMilestone,
      lecturerTitle,
    };
    
    console.log('Profile Form Data:', formData);
    // TODO: Implement save logic
  };

  return (
    <ProfileView
      dataProfile={user}
      selectedValue2={selectedValue2}
      options2={options2}
      onValueChange2={onValueChange2}
      // TextField states
      phoneNumber={phoneNumber}
      setPhoneNumber={setPhoneNumber}
      oldTeacherCode={oldTeacherCode}
      setOldTeacherCode={setOldTeacherCode}
      workPlace={workPlace}
      setWorkPlace={setWorkPlace}
      position={position}
      setPosition={setPosition}
      extraDuty={extraDuty}
      setExtraDuty={setExtraDuty}
      laborType={laborType}
      setLaborType={setLaborType}
      employmentType={employmentType}
      setEmploymentType={setEmploymentType}
      appointmentDecision={appointmentDecision}
      setAppointmentDecision={setAppointmentDecision}
      appointmentDate={appointmentDate}
      setAppointmentDate={setAppointmentDate}
      issuingAgency={issuingAgency}
      setIssuingAgency={setIssuingAgency}
      jobBeforeRecruitment={jobBeforeRecruitment}
      setJobBeforeRecruitment={setJobBeforeRecruitment}
      allowanceSeniorityDate={allowanceSeniorityDate}
      setAllowanceSeniorityDate={setAllowanceSeniorityDate}
      workAllowancePercent={workAllowancePercent}
      setWorkAllowancePercent={setWorkAllowancePercent}
      teacherAllowancePercent={teacherAllowancePercent}
      setTeacherAllowancePercent={setTeacherAllowancePercent}
      teacherType={teacherType}
      setTeacherType={setTeacherType}
      academicUnit={academicUnit}
      setAcademicUnit={setAcademicUnit}
      subjectDepartment={subjectDepartment}
      setSubjectDepartment={setSubjectDepartment}
      employmentStatus={employmentStatus}
      setEmploymentStatus={setEmploymentStatus}
      workStartDate={workStartDate}
      setWorkStartDate={setWorkStartDate}
      currentContractType={currentContractType}
      setCurrentContractType={setCurrentContractType}
      contractStartDate={contractStartDate}
      setContractStartDate={setContractStartDate}
      contractEndDate={contractEndDate}
      setContractEndDate={setContractEndDate}
      currentContractNumber={currentContractNumber}
      setCurrentContractNumber={setCurrentContractNumber}
      contractEffectiveDate={contractEffectiveDate}
      setContractEffectiveDate={setContractEffectiveDate}
      fullTimeWorkStartDate={fullTimeWorkStartDate}
      setFullTimeWorkStartDate={setFullTimeWorkStartDate}
      lastClassificationDate={lastClassificationDate}
      setLastClassificationDate={setLastClassificationDate}
      currentWorkAllowancePercent={currentWorkAllowancePercent}
      setCurrentWorkAllowancePercent={setCurrentWorkAllowancePercent}
      salaryGrade={salaryGrade}
      setSalaryGrade={setSalaryGrade}
      currentSalaryLevel={currentSalaryLevel}
      setCurrentSalaryLevel={setCurrentSalaryLevel}
      currentSalaryCoefficient={currentSalaryCoefficient}
      setCurrentSalaryCoefficient={setCurrentSalaryCoefficient}
      salaryIncreaseMilestone={salaryIncreaseMilestone}
      setSalaryIncreaseMilestone={setSalaryIncreaseMilestone}
      lecturerTitle={lecturerTitle}
      setLecturerTitle={setLecturerTitle}
      // Handlers
      onSave={handleSave}
    />
  );
};

export default Profile;
