import React, {useState} from 'react';
import {
  Modal,
  View,
  Text,
  TextInput,
  TouchableOpacity,
  StyleSheet,
  Image,
} from 'react-native';
import TextMulti from '../../../../components/Input/TextMulti';
import R from '../../../../assets/R';
import Button from '../../../../components/Button';
import styles from './style';

const WorkReportModal = ({visible, onClose, onSubmit}) => {
  const [reportContent, setReportContent] = useState('');

  const handleSubmit = () => {
    if (reportContent.trim()) {
      onSubmit(reportContent);
      setReportContent('');
      onClose();
    }
  };

  const handleCancel = () => {
    setReportContent('');
    onClose();
  };

  return (
    <Modal
      visible={visible}
      transparent={true}
      animationType="slide"
      onRequestClose={onClose}>
      <View style={styles.overlay}>
        <View style={styles.modalContainer}>
          <Text style={styles.title}>Báo cáo công việc</Text>
          <TextMulti
            placeholder="Nhập nội dung báo cáo..."
            title="Nội dung báo cáo"
            required={true}
            containerMarginBottom={10}
          />

          <Text style={styles.label}>Tài liệu đính kèm</Text>
          <TouchableOpacity style={styles.attachmentContainer}>
            <Image source={R.images.icDocument} style={styles.uploadIcon} />
            <Text style={styles.attachmentText}>Thêm tài liệu</Text>
          </TouchableOpacity>

          <View style={styles.buttonContainer}>
            <Button
              title="Huỷ"
              height={35}
              width={100}
              backgroundColor={R.colors.orange}
              borderRadius={100}
              fontSize={R.fontsize.fontSizeContent}
              onPress={handleCancel}
              txtStyle={{
                color: R.colors.white,
                fontWeight: '600',
                fontFamily: R.fonts.fontMedium,
              }}
              marginRight={10}
            />
            <Button
              title="Báo cáo"
              height={35}
              width={100}
              backgroundColor={R.colors.blue}
              borderRadius={100}
              fontSize={R.fontsize.fontSizeContent}
              onPress={handleSubmit}
              txtStyle={{
                color: R.colors.white,
                fontWeight: '600',
                fontFamily: R.fonts.fontMedium,
              }}
            />
          </View>
        </View>
      </View>
    </Modal>
  );
};

export default WorkReportModal;
