import React from 'react';
import {View, Text, StyleSheet, Image, TouchableOpacity} from 'react-native';
import styles from './style';
const ItemGrid = ({item, onPress}) => {
  return (
    <TouchableOpacity onPress={onPress} style={styles.menu_item}>
      <View style={styles.icon_container}>
        <Image source={item.icon} style={styles.icon} />
      </View>
      <Text style={styles.menu_text}>{item.title}</Text>
    </TouchableOpacity>
  );
};

export default ItemGrid;
