import { DrawerContent, DrawerContentScrollView, useDrawerProgress } from "@react-navigation/drawer"
import { useMemo } from "react";
import {
    View,
    Text,
    Image,
    TouchableOpacity,
  } from "react-native";
import * as ScreenName from "../ScreenNames"
import R from "../../assets/R";
import { useCallback } from "react";
import styles from "./style";
const CustomDrawerMailContent = (props) => {
    const {navigation, state} = props; 
    const progress = useDrawerProgress();
    const configScreen = useMemo(() => [
        {
            label: 'Hộp thư đến',
            screenName: ScreenName.EMAIL,
            icon: R.images.icMail
        },
        {
            label:'Đã gửi',
            screenName: ScreenName.SENDEMAIL,
            icon: R.images.icSend
        },
        {
            label:'Thùng rác',
            screenName: ScreenName.TRASHEMAIL,
            icon: R.images.icTrash
        }
    ],[]);

    const currentRouteName = state.routes[state.index]?.name;

    const handleScreenNavigation = useCallback((screenName) =>{
            navigation.navigate(screenName);
            navigation.closeDrawer();
        }, [navigation]
    );

    const renderItem = useCallback(
        (item) => {
            const isSel = currentRouteName === item.screenName;
            return(
                <TouchableOpacity
                    key={item.screenName}
                    style={[styles.itemContainer, isSel && styles.itemSel]}
                    onPress={() => handleScreenNavigation(item.screenName)}
                >
                    <Image
                        source={item.icon}
                        style={styles.icon}
                        resizeMode="contain"
                        tintColor={isSel ? R.colors.white : R.colors.black}
                    />
                    <Text style={[
                        styles.label,
                        isSel && styles.labelSel
                    ]}>{item.label}</Text>

                </TouchableOpacity>
            );
        },
        [currentRouteName, handleScreenNavigation]
    );

    return(
        <DrawerContentScrollView
            {...props}
            contentContainerStyle= {styles.scrollView}
        >
            <View style ={styles.logoContainer}>
                <Image
                    source={R.images.igLogo}
                    style={styles.logo}
                    resizeMode="contain"
                />
            </View>

            <View style={styles.itemSection}>
                {configScreen.map(renderItem)}
            </View>
            

        </DrawerContentScrollView>
    )
}
export default CustomDrawerMailContent;