import {StyleSheet, Text, View} from 'react-native';
import R from '../../assets/R';

const styles = StyleSheet.create({
  container: {
    flex: 1,
    backgroundColor: R.colors.white,
  },
  body: {
    flex: 1,
    backgroundColor: R.colors.white,
  },
  cardTabView: {},
  itemTabView: {
    width: 103,
    height: 35,
    borderRadius: 10,
    marginTop: 10,
    backgroundColor: R.colors.gray,
    alignItems: 'center',
    justifyContent: 'center',
    marginLeft: 15,
  },
  textTabView: {
    fontSize: R.fontsize.fontSizeContent,
    fontWeight: '400',
    color: R.colors.black,
    fontFamily: R.fonts.fontRegular,
  },
  activeTab: {
    backgroundColor: R.colors.blue,
  },
  activeTabText: {
    color: R.colors.white,
    fontWeight: '500',
  },
  contentContainerStyle: {},
  card: {
    borderWidth: 1,
    borderColor: R.colors.grayBorderInputTextHeader,
    borderRadius: 10,
    padding: 5,
    marginVertical:10,
    marginHorizontal: 15,
    alignItems: 'center',
    justifyContent: 'center',

    backgroundColor: R.colors.white,
    shadowColor: R.colors.black,
    shadowOffset: {width: 0.5, height: 2},
    shadowOpacity: Platform.OS === 'ios' ? 0.25 : 1,
    shadowRadius: 5,
    elevation: Platform.OS === 'ios' ? 1 : 2,
  },
  btnCard: {
    borderRadius: 10,
    borderWidth: 1,
    padding: 5,
    width: '100%',
    alignItems: 'center',
    justifyContent: 'center',
    borderColor: R.colors.grayBorderInputTextHeader,
  },
  text: {
    fontSize: R.sizes.sm,
    color: R.colors.black,
    fontFamily: R.fonts.fontRegular,
    fontWeight: '400',
  },
  box_3: {
    flexDirection: 'row',
    marginHorizontal: 15,
    alignItems: 'center',
  },
  searchBox: {
    flex: 1,
    borderWidth: 1,
    borderColor: R.colors.grayBorderInputTextHeader,
    borderRadius: 20,
    alignItems: 'center',
    justifyContent: 'flex-start',
    paddingLeft: 15,
    flexDirection: 'row',
    height: 35,
  },
  boxFilter: {
    flex: 1,
  },
  cardIncomingDocument: {
    borderRadius: 10,
    padding: 10,
    marginHorizontal: 15,
    marginVertical:7.5,
    backgroundColor: R.colors.white,
    shadowColor: R.colors.black,
    shadowOffset: {width: 0.5, height: 2},
    shadowOpacity: Platform.OS === 'ios' ? 0.25 : 1,
    elevation: Platform.OS === 'ios' ? 1 : 2,
  },
  textSubTitle: {
    fontSize: R.fontsize.fontSizeContent,
    fontWeight: '500',
    fontFamily: R.fonts.fontSemiBold,
    color: R.colors.black,
  },
  text: {
    fontSize: R.fontsize.fontSizeContent,
    fontWeight: '400',
    fontFamily: R.fonts.fontRegular,
    color: R.colors.black,
  },
});

export default styles;
