import {StyleSheet, Text, View} from 'react-native';
import R from '../../../assets/R';

const styles = StyleSheet.create({
  container: {
    flex: 1,
    backgroundColor: R.colors.white,
  },
  body: {
    flex: 1,
    padding: 15,
  },
  containerInput: {
    flexDirection: 'row',
    marginBottom: 15,
  },
  containerDropDown: {
    marginTop: 15,
  },
  txtSubtitle: {
    fontWeight: '400',
    fontFamily: R.fonts.fontRegular,
    fontSize: R.fontsize.fontSizeLabel,
    color: R.colors.black,
  },
  btnSubmit: {
    backgroundColor: R.colors.blue,
    padding: 15,
    alignItems: 'center',
    borderRadius: 7,
    marginTop: 15,
  },
  txtSubmit: {
    color: R.colors.white,
    fontSize: R.fontsize.fontSizeContent,
    fontFamily: R.fonts.fontMedium,
    fontWeight: '600',
  },
  cardDocument: {
    flexDirection: 'column',
    alignItems: 'center',
    backgroundColor: R.colors.white,
    padding: 15,
    borderRadius: 5,
    borderWidth: 1,
    borderColor: R.colors.blue,
  },
  // Styles cho spacing và layout
  flexOne: {
    flex: 1,
  },
  flexSpacer: {
    flex: 0.1,
  },
  marginBottom35: {
    marginBottom: 35,
  },
  marginTop15: {
    marginTop: 15,
  },
  marginBottom5: {
    marginBottom: 5,
  },
  // Styles cho text
  titleText: {
    marginBottom: 5,
    fontSize: R.fontsize.fontSizeContent,
    fontWeight: '600',
    fontFamily: R.fonts.fontMedium,
  },
  requiredText: {
    color: R.colors.red,
  },
  documentText: {
    color: R.colors.blue,
    fontWeight: '600',
    fontFamily: R.fonts.fontMedium,
  },
  // Styles cho row layout
  rowLayout: {
    flexDirection: 'row',
  },
});

export default styles;
