import React from 'react';
import {
  Text,
  View,
  TouchableOpacity,
  StyleSheet,
  FlatList,
  Image,
} from 'react-native';
import styles from './style';
import Header from '../../components/Header/Header';
import R from '../../assets/R';
import {useNavigation} from '@react-navigation/native';
import * as ScreenName from '../../routers/ScreenNames';
const FeedBackView = props => {
  const {dataList, setDataList} = props;
  const navigation = useNavigation();
  const renderCard = () => {
    return (
      <View style={styles.card}>
        <TouchableOpacity style={styles.btnCard}>
          <Text style={[styles.text, {fontFamily: R.fonts.fontMedium, fontWeight: '600'}]}>Học kỳ 2, Năm 2025</Text>
        </TouchableOpacity>
      </View>
    );
  };
  const renderItem = ({item}) => {
    return (
      <TouchableOpacity
        onPress={() => {
          navigation.navigate(ScreenName.DETAILFEEDACK);
        }}
        style={styles.containerCard}>
        <View>
          <View>
            <Text
              style={[
                styles.text,
                {
                  fontWeight: '600',
                  fontFamily: R.fonts.fontMedium,
                  color: R.colors.blue,
                },
              ]}>
              Lớp: {item.classCode}
            </Text>
          </View>
          <View>
            <Text style={styles.text}>
              Mở đánh giá từ: {item.evaluationOpenDate}
            </Text>
          </View>
        </View>

        <View>
          <Text style={[styles.text]}>GPA: {item.gpa}</Text>
        </View>

        <View style={styles.btnRight}>
          <Image
            source={R.images.icNext}
            style={{width: 20, height: 20}}
            resizeMode="contain"
            tintColor={R.colors.black}
          />
        </View>
      </TouchableOpacity>
    );
  };

  const renderList = () => {
    return (
      <FlatList
        data={dataList || []}
        renderItem={renderItem}
        showsVerticalScrollIndicator={false}
        vertical
        keyExtractor={(item, index) => `${index}`}
      />
    );
  };

  const renderItemEmpty = () => {
    return (
      <View style={styles.containerEmpty}>
        <Image source={R.images.icNoData} maxWidth={50} maxHeight={50} />
        <Text style={styles.textEmpty}>Không có dữ liệu</Text>
      </View>
    );
  };

  const renderBody = () => {
    return (
      <View style={styles.body}>
        {renderCard()}
        <View style={{flex: 1, justifyContent: 'center'}}>
          {dataList.length === 0 ? renderItemEmpty() : renderList()}
        </View>
      </View>
    );
  };

  return (
    <View style={styles.container}>
      <Header title={'Đánh giá giảng dạy'} isBack />
      {renderBody()}
    </View>
  );
};

export default FeedBackView;
