import {StyleSheet, Platform} from 'react-native';
import R from '../../../assets/R';

const styles = StyleSheet.create({
  safeArea: {
    flex: 1,
    backgroundColor: R.colors.white,
  },
  container: {
    marginHorizontal: 15,
  },
  boxInput: {
    padding: 7,
    borderColor: R.colors.grayBorderInputTextHeader,
    borderWidth: 1,
    borderRadius: 10,
    marginVertical: 10,
    backgroundColor: R.colors.brown,
  },
  txtInput: {
    color: R.colors.white,
    fontSize: R.fontsize.fontSizeLabel,
    fontFamily: R.fonts.fontMedium,
    fontWeight: '600',
  },
  containerRow: {
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'center',
  },
  text: {
    fontSize: R.fontsize.fontSizeLabel,
    fontFamily: R.fonts.fontMedium,
    fontWeight: '600',
    color: R.colors.black,
  },
  //Item
  chip: {
    flexDirection: 'row',
    alignItems: 'center',
    // position: 'relative',
    paddingLeft: 10,
    paddingRight: 10,
    height: 25,
    borderRadius: 10,
    marginBottom: 10,
    marginRight: 5,
    // top: 10,
    // left: 10,
    backgroundColor: R.colors.blue2,
    alignSelf: 'flex-start',
  },
  imageIcon: {
    width: 15,
    height: 15,
  },
  containerIcon: {
    marginRight: 2,
  },
  text: {
    fontSize: 12,
    fontWeight: '300',
    fontFamily: R.fonts.fontRegular,
    color: R.colors.blueTextChip,
    marginRight: 10,
  },
  //FlatList
  flatList: {
    height: 200,
    backgroundColor: R.colors.blue1,
    paddingHorizontal: 10,
    borderRadius: 10,
    paddingVertical: 15,
    flexDirection: 'row',
    marginBottom: 15,
  },
  flatListSelect: {
    flexDirection: 'row',
    flexWrap: 'wrap',
  },
  sizedBox: {
    height: 15,
  },
  card: {
    alignItems: 'center',
    justifyContent: 'center',
    padding: 10,
    borderRadius: 10,
    backgroundColor: R.colors.white,
    borderWidth: 1,
    borderColor: R.colors.blue,
    height: 90,
  },
  txtCard: {
    fontSize: 12,
    fontWeight: '300',
    fontFamily: R.fonts.fontRegular,
    color: R.colors.blueTextChip,
  },
  //ContainerBtn
  containerBtn: {
    flexDirection: 'row',
    justifyContent: 'space-between',
  },
  containerInput: {
    flex: 10,
  },
  txtSubtitle: {
    fontSize: R.fontsize.fontSizeSubTitle,
    fontFamily: R.fonts.fontMedium,
    fontWeight: '600',
    color: R.colors.black,
    marginBottom: 15,
  },
  text: {
    fontSize: R.fontsize.fontSizeContent,
    fontFamily: R.fonts.fontRegular,
    fontWeight: '400',
    color: R.colors.black,
  },
  containerDropdown: {
    marginBottom: 15,
    position: 'relative',
    zIndex: 1000,
  },
});
export default styles;
