import {StyleSheet, Text, View} from 'react-native';
import React from 'react';
import R from '../../../assets/R';

const styles = StyleSheet.create({
  container: {
    flex: 1,
    backgroundColor: R.colors.white,
  },
  body: {
    flex: 1,
    backgroundColor: R.colors.white,
    marginHorizontal: 15,
    marginVertical: 10,
  },
  textSubTitle: {
    fontSize: R.fontsize.fontSizeSubTitle,
    fontWeight: '600',
    fontFamily: R.fonts.fontMedium,
    color: R.colors.black,
  },
  text_1: {
    fontSize: R.fontsize.fontSizeContent,
    fontWeight: '400',
    fontFamily: R.fonts.fontRegular,
    color: R.colors.blue,
  },
  text: {
    fontSize: R.fontsize.fontSizeContent,
    fontWeight: '600',
    fontFamily: R.fonts.fontMedium,
    color: R.colors.black,
  },
  text_2: {
    fontSize: R.fontsize.fontSizeContent,
    fontWeight: '400',
    fontFamily: R.fonts.fontRegular,
    color: R.colors.gray4,
  },
  textBtn: {
    color: R.colors.black,
    fontSize: R.sizes.xs,
    fontWeight: '400',
    fontFamily: R.fonts.fontRegular,
  },
  containerContent: {
    padding: 10,
    borderRadius: 10,
    borderWidth: 1,
    borderColor: R.colors.grayBorderInputTextHeader,
  },
  cardContainerContent: {
    backgroundColor: R.colors.white,
    padding: 10,
    borderRadius: 10,
    borderWidth: 1,
    borderColor: R.colors.grayBorderInputTextHeader,
  },
  card: {
    borderWidth: 1,
    borderColor: R.colors.grayBorderInputTextHeader,
    borderRadius: 100,
    paddingHorizontal: 5,
    height:35,
    alignSelf: 'flex-start',
    justifyContent: 'center',
    backgroundColor: R.colors.orange,
    marginHorizontal: 5,
  },
  containerBtn: {
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'space-around',
    marginVertical: 10,
    borderRadius: 10,
    backgroundColor: R.colors.blue1,
    height:35,
    width: 300,
    alignItems: 'center',
  },
  //MODAL Thêm Bút Phê
  modalOverlay: {
    flex: 1,
    backgroundColor: 'rgba(0, 0, 0, 0.5)',
    justifyContent: 'center',
    alignItems: 'center',
  },
  modalContainer: {
    backgroundColor: 'white',
    borderRadius: 10,
    width: '90%',
    maxHeight: '80%',
  },
  modalHeader: {
    flexDirection: 'row',
    justifyContent: 'center',
    alignItems: 'center',
    padding: 10,
  },
  modalTitle: {
    fontSize: R.fontsize.fontsSizeTitle,
    fontWeight: '600',
    fontFamily: R.fonts.fontMedium,
    color: R.colors.blue,
  },
  closeButton: {
    width: 30,
    height: 30,
    justifyContent: 'center',
    alignItems: 'center',
  },
  closeButtonText: {
    fontSize: R.fontsize.fontSizeContent,
    color: R.colors.gray,
    fontWeight: 'bold',
  },
  modalBody: {
    paddingHorizontal: 15,
  },
  inputLabel: {
    fontSize: R.fontsize.fontSizeSubTitle,
    color: R.colors.black,
    marginBottom: 3,
    fontWeight: '400',
    fontFamily: R.fonts.fontRegular,
  },
  textInput: {
    borderWidth: 1,
    borderColor: R.colors.grayBorderInputTextHeader,
    borderRadius: 8,
    padding: 12,
    fontSize: R.fontsize.fontSizeContent,
    color: R.colors.black,
    minHeight: 120,
    textAlignVertical: 'top',
  },
  modalFooter: {
    flexDirection: 'row',
    justifyContent: 'flex-end',
    padding: 15,
  },
  button: {
    paddingHorizontal: 20,
    paddingVertical: 3,
    borderRadius: 30,
    width: 110,
    alignItems: 'center',
    justifyContent: 'center',
  },
  cancelButton: {
    backgroundColor: R.colors.orange,
    marginRight: 10,
  },
  cancelButtonText: {
    color: R.colors.white,
    fontSize: R.fontsize.fontSizeContent,
    fontFamily: R.fonts.fontRegular,
    fontWeight: '400',
  },
  submitButton: {
    backgroundColor: R.colors.blue,
  },
  submitButtonText: {
    color: 'white',
    fontSize: R.fontsize.fontSizeContent,
    fontFamily: R.fonts.fontRegular,
    fontWeight: '400',
  },
  //MODAL Thêm công việc
  containerDropdown: {
    marginBottom: 10,
    marginTop: 10,
    position: 'relative',
    zIndex: 1000,
  },
  chip: {
    flexDirection: 'row',
    alignItems: 'center',
    // position: 'relative',
    paddingLeft: 10,
    paddingRight: 10,
    height: 25,
    borderRadius: 10,
    marginBottom: 10,
    marginRight: 5,
    backgroundColor: R.colors.blue2,
    alignSelf: 'flex-start',
  },
  imageIcon: {
    width: 15,
    height: 15,
  },
  containerIcon: {
    marginRight: 2,
  },

  flatListSelect: {
    flexDirection: 'row',
    flexWrap: 'wrap',
  },
  textChip: {
    fontSize: R.fontsize.fontSizeContent,
    fontWeight: '400',
    fontFamily: R.fonts.fontRegular,
    color: R.colors.blueTextChip,
  },
});

export default styles;
