import {StyleSheet, Platform} from 'react-native';
import R from '../../assets/R';

const styles = StyleSheet.create({
  //Header
  containerBoxHeader: {
    flexDirection: 'row',
    marginHorizontal: 15,
    maxHeight: Platform.OS === 'ios' ? 70 : 40,
    marginTop: 15,
  },
  boxLogo: {
    flex: 2,
    maxWidth: 75,
    maxHeight: 36,
  },
  boxIconSearch: {
    padding: 2,
  },
  searchBox: {
    flex: 3,
    flexDirection: 'row',
    backgroundColor: R.colors.blackBackgroundInputTextHeader,
    alignItems: 'center',
    borderColor: R.colors.grayBorderInputTextHeader,
    borderRadius: 100,
    borderWidth: 1,
    paddingHorizontal: 14,
    height: 35,
  },

  input: {
    fontSize: R.fontsize.fontsSize12,
    color: R.colors.white,
    height: 30,
    flex: 1,
    fontFamily: R.fonts.InterRegular,
    fontWeight: '400',
    margin: 0,
    padding: 0,
  },
  //Home
  safeArea: {
    flex: 1,
  },
  container_body: {
    flex: 1,
    backgroundColor: R.colors.white,
  },
  background_header: {
    height: 295,
    position: 'relative',
  },
  profileCard: {
    position: 'absolute',
    bottom: -30,
    flexDirection: 'row',
    alignItems: 'center',
    backgroundColor: R.colors.white,
    paddingVertical: 10,
    paddingHorizontal: 15,
    marginHorizontal: 15,
    borderRadius: 15,
    shadowColor: R.colors.black,
    shadowOffset: {width: 0, height: 1},
    shadowOpacity: 0.5,
    shadowRadius: 1,
    elevation: 1,
  },
  profile_left: {
    flexDirection: 'row',
    alignItems: 'center',
    flex: 3,
  },

  avatar: {
    width: Platform.OS === 'ios' ? 37 : 47,
    height: Platform.OS === 'ios' ? 37 : 47,
    borderRadius: 100,
    backgroundColor: R.colors.gray,
    overflow: 'hidden',
  },
  avatar_image: {
    width: '100%',
    height: '100%',
  },
  avatar_placeholder: {
    width: '100%',
    height: '100%',
    justifyContent: 'center',
    alignItems: 'center',
    backgroundColor: R.colors.blue,
  },
  avatar_text: {
    fontSize: R.sizes.h6,
    color: R.colors.white,
    fontFamily: R.fonts.fontMedium,
  },
  information: {
    flex: 2,
    marginLeft: 10,
  },
  text_card_info: {
    fontSize: R.fontsize.fontSizeContent,
    fontWeight: '400',
    color: R.colors.black,
    fontFamily: R.fonts.InterRegular,
  },
  profile_btn: {
    paddingVertical: 5,
    paddingHorizontal: 10,
    backgroundColor: R.colors.grayButton,
    borderRadius: 15,
    flexDirection: 'row',
    justifyContent: 'center',
    alignItems: 'center',
  },
  iconNext: {
    marginLeft: 5,
  },
  btn_text: {
    fontSize: R.sizes.sm,
    fontWeight: '400',
    color: R.colors.black,
    fontFamily: R.fonts.fontRegular,
  },

  menu_container: {
    marginHorizontal: 15,
  },
  menu_title: {
    fontSize: R.fontsize.fontSizeSubTitle,
    fontWeight: '600',
    color: R.colors.black,
    fontFamily: R.fonts.fontMedium,
  },
  scroll: {
    flex: 1,
    marginTop: 35,
  },
  cardItemEmpty: {
    flex: 1,
    justifyContent: 'center',
    alignItems: 'center',
  },

  //Item
  menu_item: {
    alignItems: 'center',
    paddingVertical: 10,
    paddingHorizontal: 5,
    marginHorizontal: 5,
    marginVertical: 5,
    flex: 1,
    maxWidth: '30%',
    minHeight: '30%',
  },
  icon_container: {
    width: 35,
    height: 35,
    backgroundColor: R.colors.white,
  },
  icon: {
    width: 35,
    height: 35,
    resizeMode: 'contain',
  },
  menu_text: {
    fontSize: R.sizes.sm,
    fontWeight: '600',
    color: R.colors.black,
    fontFamily: R.fonts.fontMedium,
    textAlign: 'center',
  },
});

export default styles;
