import React from 'react';
import {Text, View, FlatList, ScrollView, LogBox} from 'react-native';
import styles from './style';
import Header from '../../../components/Header/Header';
import TextField from '../../../components/Input/TextField';
import R from '../../../assets/R';
import TextMulti from '../../../components/Input/TextMulti';
import Button from '../../../components/Button';
const NotificationDetailView = props => {
  const {
    showWarning,
    title,
    onTitleChange,
    options,
    selectedValue,
    onValueChange,
    disabled,
    size,
    color,
    direction,
    dataList,
  } = props;
  LogBox.ignoreLogs(['VirtualizedLists should never be nested']);
  const renderItem = ({item, onPress}) => {
    return (
      <View style={styles.chip}>
        {/* <TouchableOpacity style={styles.containerIcon} onPress={onPress}>
        <Image
          resizeMode="cover"
          source={R.images.icCancel}
          style={styles.imageIcon}
        />
      </TouchableOpacity> */}
        <Text style={styles.text}> {`${item.id}, ${item.name}`}</Text>
      </View>
    );
  };

  return (
    <View style={styles.safeArea}>
      <Header isBack title={'Chi tiết thông báo'} />
      <ScrollView
        showsVerticalScrollIndicator={false}
        contentContainerStyle={{paddingBottom: 20}}>
        <View style={styles.container}>
          {
            <View style={styles.boxInput}>
              <Text style={styles.txtInput}>
                Bạn không thể chỉnh sửa thông báo khi đã gửi{' '}
              </Text>
            </View>
          }

          <TextField
            title="Tiêu đề thông báo"
            value={title}
            onChangeText={onTitleChange}
            placeholder="HS"
            backgroundColor={R.colors.blue1}
            color={R.colors.white}
            fontSize={R.sizes.sm}
            onFocus={() => {}}
            fontSizeTitle={R.sizes.sm}
            containerMarginBottom={15}
            required
            editable={false}
          />

          <TextField
            title="Mã CBGV"
            value={title}
            onChangeText={onTitleChange}
            placeholder="HS"
            backgroundColor={R.colors.blue1}
            color={R.colors.white}
            fontSize={R.sizes.sm}
            onFocus={() => {}}
            fontSizeTitle={R.sizes.sm}
            required
            containerMarginBottom={15}
            editable={false}
          />
          <TextMulti
            title="Nội dung thông báo"
            fontFamily={R.fonts.fontRegular}
            titleFontSize={R.sizes.sm}
            value={title}
            onChangeText={onTitleChange}
            placeholder="Thông tin nội dung thông báo sẽ được hiển thị ở đây"
            backgroundColor={R.colors.blue1}
            color={R.colors.white}
            fontSize={R.sizes.sm}
            onFocus={() => {}}
            fontSizeTitle={R.sizes.sm}
            fontSizePlaceHolder={R.sizes.sm}
            required
            containerMarginBottom={15}
            editable={false}
          />

          {/* <RadioGroup
            options={options}
            selectedValue={selectedValue}
            onValueChange={onValueChange}
            disabled={false}
            size={20}
            backgroundBoxColor={R.colors.blue}
            borderBoxColor={R.colors.black}
            direction={'row'}
            marginBtnAndLabel={10}
            // justifyContent={'space-between'}
            containerMarginRight={39}
            containerMarginBottom={15}
            editable={false}
          /> */}
          <View>
            <Text
              style={{
                fontSize: R.fontsize.fontSizeContent,
                fontFamily: R.fonts.fontRegular,
                fontWeight: '400',
                color: R.colors.black,
                marginBottom: 5,
              }}>
              Danh sách người nhận <Text style={{color: R.colors.red}}>*</Text>
            </Text>
          </View>
          <View style={styles.flatList}>
            <FlatList
              nestedScrollEnabled={true}
              scrollEnabled={true}
              data={dataList}
              renderItem={renderItem}
              keyExtractor={item => item.id}
              numColumns={2}
              columnWrapperStyle={{flexWrap: 'wrap'}}
            />
          </View>

          <View style={styles.containerBtn}>
            <View style={styles.containerInput}>
              <TextField
                title="Ngày gửi"
                value={title}
                onChangeText={onTitleChange}
                backgroundColor={R.colors.blue1}
                color={R.colors.white}
                fontSize={R.sizes.sm}
                onFocus={() => {}}
                fontSizeTitle={R.sizes.sm}
                containerMarginBottom={15}
                editable={false}
              />
            </View>
            <View style={{flex: 1}}></View>
            <View style={styles.containerInput}>
              <TextField
                title="Thời gian gửi"
                value={title}
                onChangeText={onTitleChange}
                backgroundColor={R.colors.blue1}
                color={R.colors.white}
                fontSize={R.sizes.sm}
                onFocus={() => {}}
                fontSizeTitle={R.sizes.sm}
                containerMarginBottom={15}
                editable={false}
              />
            </View>
          </View>
          <Text style={[styles.txtSubtitle]}>Tài liệu đính kèm</Text>
          <View>
            <Button
              title="Thêm tài liệu"
              onPress={() => {}}
              backgroundColor={R.colors.blue1}
              fontSize={R.sizes.sm}
              editable={false}
              height={25}
              width={176}
              borderRadius={10}
              textColor={R.colors.blue}
              fontWeight={'600'}
              fontFamily={R.fonts.fontMedium}
              icon={R.images.icDownload}
              iconStyle={{
                width: 15,
                height: 15,
              }}
              containerStyle={{
                alignSelf: 'flex-start',
              }}
            />
          </View>
        </View>
      </ScrollView>
    </View>
  );
};

export default NotificationDetailView;
