import React from 'react';
import {
  Text,
  View,
  TouchableOpacity,
  Image,
  TextInput,
  FlatList,
} from 'react-native';
import styles from './style';
import FAB from '../../components/FAB/fab';
import SubButton from '../../components/FAB/sub_button';
import Header from '../../components/Header/Header';
import Dropdown from '../../components/DropdownAlert/Dropdown';
import R from '../../assets/R';
import TabViewComponent from '../../components/TabView';
import AddWorkModal from './modal_add_deliver_to_me/index';
import AddMonitoringModal from './modal_add_monitoring/index';
import Button from '../../components/Button';
import {ROLE} from '../../actions/actionTypes';
import ModalRequestReport from './monitoring/modal_request_report';
import WorkReportModal from './deliver_to_me/detail/modal_add_report';

const ListWorkView = props => {
  const {
    searchQuery,
    setSearchQuery,
    dataList,
    modalDeliverToMeVisible,
    modalMonitoringVisible,
    modalRequestReport,
    modalReport,

    tabView,
    currentTabKey,
    shouldShowFAB,
    onFilterChange,
    onAddWork,
    onSaveDeliverToMeWork,
    onSaveMonitoringWork,
    onSaveSumbitReport,
    onSaveSumbitRequestReport,
    onCloseDeliverToMeModal,
    onCloseMonitoringModal,
    onViewDetailDeliverToMe,
    onReportAction,
    onApprovalAction,
    getStatusColor,
    getButtonsForStatus,
    onCloseRequestReport,
    onCloseModalReport,
    onOpenModalRequestReport,
    onOpenModalReport,
  } = props;

  const renderTabView = () => {
    return (
      <TabViewComponent
        data={tabView}
        tabStyle={styles.item_tab_view}
        style={styles.container_tab_view}
        mode="filter"
        defaultActiveKey={ROLE.ALL}
        scrollable={true}
        activeTabStyle={styles.active_tab_view}
        textStyle={styles.text_tab_view}
        showActiveIndicator={false}
        onFilterChange={onFilterChange}
      />
    );
  };

  const renderActionButtons = item => {
    const buttons = getButtonsForStatus(item.status, item);

    return buttons.map((button, index) => (
      <Button
        key={index}
        title={button.title}
        onPress={() => {
          if (button.action === 'detail') {
            onViewDetailDeliverToMe(item); //Navigate
          } else if (button.action === 'requestReport') {
            onOpenModalRequestReport(item); //OpenModal
          } else if (button.action === 'report') {
            onOpenModalReport(item);
          } else if (button.action === 'approve') {
            onApprovalAction(item, 'approve');
          }
        }}
        backgroundColor={button.backgroundColor}
        textColor={R.colors.white}
        fontSize={11}
        height={30}
        width={100}
        containerStyle={styles.buttonContainerStyle}
      />
    ));
  };

  const renderListView = ({item}) => {
    return (
      <View style={styles.listItemContainer}>
        <View
          style={[
            styles.statusHeader,
            {backgroundColor: getStatusColor(item.status)},
          ]}>
          <Text style={[styles.subText, styles.statusText]}>{item.status}</Text>
        </View>
        <View style={styles.containerCard}>
          <View style={styles.cardContent}>
            <Text style={styles.text}>{item.title}</Text>
            <View style={styles.rowSpaceBetween}>
              <Text style={styles.text}>
                Ngày đến hạn:
                <Text style={styles.subText}>{item.deadline}</Text>
              </Text>
            </View>
            <Text style={styles.text}>
              Người giám sát:
              <Text style={styles.subText}>
                {item.supervisor.map(item => item.name).join(', ')}
              </Text>
            </Text>
            <Text style={styles.text}>
              Thuộc văn bản:
              <Text style={styles.subText}>{item.document}</Text>
            </Text>
          </View>

          <View style={styles.actionButtonsContainer}>
            {renderActionButtons(item)}
          </View>
        </View>
      </View>
    );
  };

  const renderCard = () => {
    return (
      <View style={styles.card}>
        <TouchableOpacity style={styles.btnCard}>
          <Text style={styles.text}>Học kỳ 2, Năm 2025</Text>
        </TouchableOpacity>
      </View>
    );
  };

  const renderFilter = () => {
    return (
      <View style={styles.box_3}>
        <View style={styles.searchBox}>
          <Image source={R.images.icSearch} style={styles.searchIcon} />
          <View style={styles.searchInputContainer}>
            <TextInput
              placeholder="Tìm kiếm"
              style={[styles.text, styles.searchInput]}
              value={searchQuery}
              onChangeText={setSearchQuery}
            />
          </View>
        </View>
        <View style={styles.filterSpacer}></View>

        <View style={styles.dropdownContainer}>
          <Dropdown title={'Tìm kiếm'} height={35} />
        </View>
      </View>
    );
  };

  const renderListItem = () => {
    return (
      <FlatList
        data={dataList}
        renderItem={renderListView}
        keyExtractor={item => item.id.toString()}
        showsVerticalScrollIndicator={false}
      />
    );
  };
  const renderBody = () => {
    return (
      <View style={styles.body}>
        {renderTabView()}
        {renderCard()}
        <View style={styles.listContainer}>
          {renderFilter()}
          {renderListItem()}
        </View>
      </View>
    );
  };

  return (
    <View style={styles.container}>
      <Header title={'Danh sách công việc'} isBack />
      {renderBody()}

      {shouldShowFAB && (
        <FAB>
          <SubButton
            onPress={onAddWork}
            label={
              currentTabKey === ROLE.ASSIGNEE ? 'Tạo công việc' : 'Tạo giám sát'
            }
            images={R.images.icMenuEdit}
            backgroundColor={R.colors.blue}
          />
        </FAB>
      )}

      <AddWorkModal
        visible={modalDeliverToMeVisible}
        onClose={onCloseDeliverToMeModal}
        onSave={onSaveDeliverToMeWork}
      />

      <AddMonitoringModal
        visible={modalMonitoringVisible}
        onClose={onCloseMonitoringModal}
        onSave={onSaveMonitoringWork}
      />

      <ModalRequestReport
        visible={modalRequestReport}
        onClose={onCloseRequestReport}
        onSubmitReport={onSaveSumbitReport}
        workData={dataList}
      />

      <WorkReportModal
        visible={modalReport}
        onClose={onCloseModalReport}
        onSubmit={onSaveSumbitReport}
      />

      {/* <EditReportModal
        visible={showEditReportModal}
        onClose={() => setShowEditReportModal(false)}
        onSubmit={handleEditReportSubmit}
        initialContent=""
      /> */}
    </View>
  );
};

export default ListWorkView;
