import React, {useState} from 'react';
import {
  Text,
  View,
  TouchableOpacity,
  Image,
  FlatList,
  ScrollView,
  LogBox,
} from 'react-native';
import styles from './style';
import FAB from '../../../components/FAB/fab';
import SubButton from '../../../components/FAB/sub_button';
import R from '../../../assets/R';
import Header from '../../../components/Header/Header';
import Dropdown from '../../../components/DropdownAlert/Dropdown';
import Button from '../../../components/Button';
import ModalRequestReport from './modal_request_report';

const DetailListWorkMonitoringView = props => {
  LogBox.ignoreLogs(['VirtualizedLists should never be nested']);
  const {
    data,
    dataList,
    dataReport,

    onOpenModalRequestReport,
    showModalRequestReport,
    onCloseModalRequestReport,
    onSubmitRequestReport,
  } = props;

  const getColor = status => {
    switch (status) {
      case 'Chờ duyệt':
        return R.colors.blue;
      case 'Hoàn thành':
        return R.colors.green;
      case 'Đợi chỉnh sửa':
        return R.colors.orange;
      case 'Đang thực hiện':
        return R.colors.orange;
      case 'Đợi báo cáo':
        return R.colors.blue;
      default:
        return R.colors.gray;
    }
  };

  const shouldShowFAB = () => {
    return data.status === 'Đang thực hiện';
  };

  const renderItem_1 = ({item, onPress}) => {
    return (
      <View style={styles.chip}>
        <TouchableOpacity
          style={styles.containerIcon}
          onPress={() => handleItemPress(item)}>
          <Image
            resizeMode="cover"
            source={R.images.icCancel}
            style={styles.imageIcon}
            tintColor={R.colors.blue}
          />
        </TouchableOpacity>
        <Text style={styles.textChip}> {`${item.id}, ${item.name}`}</Text>
      </View>
    );
  };

  const renderButton = () => {
    return (
      <View style={styles.btnRegister2}>
        <Button
          title={'Cập nhật thông tin công việc'}
          backgroundColor={R.colors.blue}
          textColor={R.colors.white}
          onPress={() => ({})}
          fontSize={R.sizes.sm}
          fontFamily={R.fonts.fontMedium}
          height={35}
          containerStyle={{paddingHorizontal: 15, borderRadius: 10}}
        />
      </View>
    );
  };

  const renderBody = item => {
    return (
      <View style={styles.body}>
        <Text
          style={[
            styles.text,
            {fontSize: R.fontsize.fontSizeSubTitle, marginBottom: 3},
          ]}>
          {data.title}
        </Text>

        <Text style={[styles.text, {marginBottom: 3, textAlign: 'right'}]}>
          Trạng thái:{' '}
          <Text style={{color: getColor(data.status)}}>{data.status}</Text>
        </Text>
        <Text style={[styles.text, {marginBottom: 3}]}>
          Công việc thuộc văn bản:{' '}
          <Text style={[styles.sub_text, {color: R.colors.blue}]}>
            {data.document}
          </Text>
        </Text>
        <Text style={[styles.text, {marginBottom: 3}]}>Nội dung công việc</Text>
        <View style={styles.containerContent}>
          <Text style={[styles.text, {color: R.colors.gray}]}>
            {data.content}
          </Text>
        </View>
        <Text style={styles.text}>
          Ngày đến hạn <Text style={{color: R.colors.red}}>*</Text>
        </Text>
        <View style={styles.containerContent}>
          <Text style={styles.text}>{data.deadline}</Text>
        </View>

        <View style={styles.containerDropDown}>
          <Text
            style={[
              styles.text,
              {
                marginBottom: 3,
              },
            ]}>
            Người theo dõi
          </Text>
          <Dropdown
            height={35}
            items={item}
            placeholder="Công việc theo văn bản"
          />
        </View>
        <Text style={[styles.text, {marginBottom: 3}]}>
          Danh sách người theo dõi đã chọn
        </Text>
        <FlatList
          data={dataList}
          renderItem={({item}) => renderItem_1({item, onPress: () => {}})}
          keyExtractor={(item, index) =>
            item.id?.toString() || index.toString()
          }
          numColumns={2}
          style={{maxHeight: 150}}
          showsVerticalScrollIndicator={true}
          columnWrapperStyle={styles.flatListSelect}
          nestedScrollEnabled={true}
          scrollEnabled={true}
        />

        <View style={styles.containerDropDown}>
          <Text
            style={[
              styles.text,
              {
                marginBottom: 3,
              },
            ]}>
            Người thực hiện công việc
          </Text>
          <Dropdown height={35} items={item} />
        </View>
        <Text style={[styles.text, {marginBottom: 3}]}>
          Danh sách người thực hiện công việc đã chọn
        </Text>
        <FlatList
          data={dataList}
          renderItem={({item}) => renderItem_1({item, onPress: () => {}})}
          keyExtractor={(item, index) =>
            item.id?.toString() || index.toString()
          }
          numColumns={2}
          style={{maxHeight: 150}}
          showsVerticalScrollIndicator={true}
          columnWrapperStyle={styles.flatListSelect}
          nestedScrollEnabled={true}
          scrollEnabled={true}
        />

        <View style={styles.containerDropDown}>
          <Text
            style={[
              styles.text,
              {
                marginBottom: 3,
              },
            ]}>
            Thẻ
          </Text>
          <Dropdown height={35} items={item} />
        </View>
        <Text style={[styles.text, {marginBottom: 3}]}>
          Danh sách thẻ đã chọn
        </Text>
        <FlatList
          data={dataList}
          renderItem={({item}) => renderItem_1({item, onPress: () => {}})}
          keyExtractor={(item, index) =>
            item.id?.toString() || index.toString()
          }
          numColumns={2}
          style={{maxHeight: 150}}
          showsVerticalScrollIndicator={true}
          columnWrapperStyle={styles.flatListSelect}
          nestedScrollEnabled={true}
          scrollEnabled={true}
        />

        <Text style={[styles.text, {marginBottom: 3}]}>Tài liệu đính kèm</Text>
        <TouchableOpacity style={styles.containerFile}>
          <Text style={[styles.text, {fontSize: R.sizes.xs}]}>
            Quyết định thông báo đào tạo - QD347583
          </Text>
          <Image source={R.images.icDownload} style={styles.image} />
        </TouchableOpacity>

        <TouchableOpacity style={styles.attachmentContainer}>
          <Image source={R.images.icDocument} style={styles.uploadIcon} />
          <Text style={styles.attachmentText}>Thêm tài liệu</Text>
        </TouchableOpacity>
        {renderButton()}
      </View>
    );
  };

  return (
    <View style={styles.container}>
      <Header title={'Chi tiết công việc giám sát'}  isBack={true}/>
      <ScrollView showsVerticalScrollIndicator={false}>
        {renderBody()}
      </ScrollView>

      {shouldShowFAB() && (
        <FAB>
          <SubButton
            onPress={onOpenModalRequestReport}
            label={'Yêu cầu báo cáo'}
            images={R.images.icEdit}
            backgroundColor={R.colors.orange}
          />
        </FAB>
      )}

      <ModalRequestReport
        visible={showModalRequestReport}
        onClose={onCloseModalRequestReport}
        onSubmitReport={onSubmitRequestReport}
        workData={data}
      />
    </View>
  );
};

export default DetailListWorkMonitoringView;
