import { StyleSheet } from "react-native";
import R from "../../../../../assets/R";

const styles = StyleSheet.create({
  overlay: {
    flex: 1,
    backgroundColor: R.colors.blackShadow,
    justifyContent: 'center',
    alignItems: 'center',
  },
  modalContainer: {
    backgroundColor: R.colors.white,
    borderRadius: 12,
    padding: 20,
    width: '90%',
    maxWidth: 400,
  },
  title: {
    fontSize: R.fontsize.fontsSizeTitle,
    fontWeight: '600',
    color: R.colors.blue,
    textAlign: 'center',
  },
  description: {
    fontSize: R.fontsize.fontSizeContent,
    color: R.colors.gray1,
    lineHeight: 18,
    marginBottom: 10,
    textAlign: 'left',
    borderWidth: 1,
    borderColor: R.colors.grayBorderInputTextHeader,
    borderRadius: 10,
    padding: 10,
  },
  required: {
    color: R.colors.red,
  },

  attachedFileContainer: {
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'space-between',
    backgroundColor: R.colors.blue1,
    borderRadius: 10,
    padding: 10,
    marginBottom: 10,
  },
  text: {
    fontSize: R.fontsize.fontSizeContent,
    fontFamily: R.fonts.fontMedium,
    fontWeight: '600',
    color: R.colors.black,
  },
  fileName: {
    fontSize: R.sizes.xs,
    color: R.colors.black,
  },
  deleteIcon: {
    width: 20,
    height: 20,
    tintColor: R.colors.blue,
  },
  attachmentContainer: {
    borderWidth: 1,
    borderColor: R.colors.blue,
    borderRadius: 10,
    padding: 20,
    alignItems: 'center',
    marginBottom: 20,
  },
  uploadIcon: {
    width: 23,
    height: 28,
    tintColor: R.colors.blue,
    marginBottom: 5,
  },
  attachmentText: {
    fontSize: 14,
    color: R.colors.blue,
    fontWeight: '500',
  },
  buttonContainer: {
    flexDirection: 'row',
    justifyContent: 'flex-end',
  },
  cancelButton: {
    flex: 1,
    backgroundColor: R.colors.orange,
    borderRadius: 8,
    paddingVertical: 12,
    alignItems: 'center',
  },
  submitButton: {
    flex: 1,
    backgroundColor: R.colors.blue,
    borderRadius: 8,
    paddingVertical: 12,
    alignItems: 'center',
  },
  cancelButtonText: {
    color: R.colors.white,
    fontSize: 16,
    fontWeight: '600',
  },
  submitButtonText: {
    color: R.colors.white,
    fontSize: 16,
    fontWeight: '600',
  },
});

export default styles