import React, { useState } from 'react';
import {Text, View, StyleSheet} from 'react-native';
import RegisterAbsenceView from './view';

const RegisterAbsence = props => {
  // State cho các TextField
  const [semester, setSemester] = useState('');
  const [academicYear, setAcademicYear] = useState('');
  const [teacherCode, setTeacherCode] = useState('');
  const [reason, setReason] = useState('');
  
  // State cho các Dropdown
  const [selectedClass, setSelectedClass] = useState('');
  const [selectedSchedule, setSelectedSchedule] = useState('');
  const [selectedSubstituteTeacher, setSelectedSubstituteTeacher] = useState('');
  
  // State cho document
  const [selectedDocument, setSelectedDocument] = useState(null);

  const handleSubmit = () => {
    // Validation
    if (!semester.trim()) {
      alert('Vui lòng nhập học kỳ');
      return;
    }
    if (!academicYear.trim()) {
      alert('Vui lòng nhập năm học');
      return;
    }
    if (!teacherCode.trim()) {
      alert('Vui lòng nhập mã CBGV');
      return;
    }
    if (!selectedClass) {
      alert('Vui lòng chọn mã lớp');
      return;
    }
    if (!selectedSchedule) {
      alert('Vui lòng chọn lịch báo nghỉ');
      return;
    }
    if (!reason.trim()) {
      alert('Vui lòng nhập lý do nghỉ');
      return;
    }
    if (!selectedSubstituteTeacher) {
      alert('Vui lòng chọn giảng viên thay thế');
      return;
    }

    // Tạo object data để submit
    const formData = {
      semester: semester.trim(),
      academicYear: academicYear.trim(),
      teacherCode: teacherCode.trim(),
      selectedClass,
      selectedSchedule,
      reason: reason.trim(),
      selectedSubstituteTeacher,
      document: selectedDocument,
    };

    console.log('Form Data:', formData);
    // TODO: Implement submit logic
  };

  const handleDocumentPicker = () => {
    // TODO: Implement document picker
    console.log('Open document picker');
  };

  return (
    <RegisterAbsenceView 
      // Text field states
      semester={semester}
      setSemester={setSemester}
      academicYear={academicYear}
      setAcademicYear={setAcademicYear}
      teacherCode={teacherCode}
      setTeacherCode={setTeacherCode}
      reason={reason}
      setReason={setReason}
      
      // Dropdown states
      selectedClass={selectedClass}
      setSelectedClass={setSelectedClass}
      selectedSchedule={selectedSchedule}
      setSelectedSchedule={setSelectedSchedule}
      selectedSubstituteTeacher={selectedSubstituteTeacher}
      setSelectedSubstituteTeacher={setSelectedSubstituteTeacher}
      
      // Document state
      selectedDocument={selectedDocument}
      setSelectedDocument={setSelectedDocument}
      
      // Handlers
      onSubmit={handleSubmit}
      onDocumentPicker={handleDocumentPicker}
    />
  );
};

export default RegisterAbsence;
