import React from 'react';
import {
  Text,
  View,
  TouchableOpacity,
  FlatList,
  Image,
  TextInput,
} from 'react-native';
import styles from './style';
import Header from '../../components/Header/Header';
import Dropdown from '../../components/DropdownAlert/Dropdown';
import R from '../../assets/R';
import Button from '../../components/Button';
import * as ScreenName from '../../routers/ScreenNames';
import {useNavigation} from '@react-navigation/native';
const IncomingDocumentView = props => {
  const {
    activeTab,
    dataListTabView,
    dataList,
    searchQuery,
    setSearchQuery,
    handleTabKey,
  } = props;
  const navigation = useNavigation();
  const getColor = status => {
    switch (status) {
      case 'Hạn chế':
        return R.colors.brown;
      case 'Công khai':
        return R.colors.blue;
    }
  };

  const hasRelatedWork = n => Number(n) > 0;
  const getHiddenButton = n => (hasRelatedWork(n) ? true : false);

  const itemTabView = ({item, index}) => {
    const isActive = item.key === activeTab;
    return (
      <TouchableOpacity
        style={[styles.itemTabView, isActive ? styles.activeTab : null]}
        onPress={() => handleTabKey && handleTabKey(item.key)}>
        <Text
          style={[styles.textTabView, isActive ? styles.activeTabText : null]}>
          {item.title_status}
        </Text>
      </TouchableOpacity>
    );
  };

  const renderItemIncomingDocument = ({item}) => {
    const showRelatedWork = getHiddenButton(item?.total_head_of_work);
    return (
      <View style={styles.cardIncomingDocument}>
        <Text style={styles.textSubTitle}>{item.title}</Text>
        <View style={{flexDirection: 'row', justifyContent: 'space-between'}}>
          <Text style={styles.textSubTitle}>
            Số ký hiệu: <Text style={styles.text}>{item.symbol_number}</Text>
          </Text>
          <Text style={styles.textSubTitle}>
            Số vào sổ: <Text style={styles.text}>{item.number_entry_book}</Text>
          </Text>
        </View>
        <View style={{flexDirection: 'row', justifyContent: 'space-between'}}>
          <Text style={styles.textSubTitle}>
            Ngày đến: <Text style={styles.text}>{item.term}</Text>
          </Text>
          <Text style={styles.textSubTitle}>
            Chế độ:{' '}
            <Text style={[{color: getColor(item.status)}]}>{item.status}</Text>
          </Text>
        </View>
        <Text style={{alignSelf: 'flex-start', color: R.colors.blue}}>
          Văn bản hiện có {item.total_head_of_work || 0} công việc liên quan
        </Text>

        <View
          style={{
            flexDirection: 'row',
            alignSelf: 'flex-end',
            marginVertical: 5,
          }}>
          {showRelatedWork && (
            <Button
              title="Công việc"
              onPress={() => {}}
              backgroundColor={R.colors.orange}
              textColor={R.colors.white}
              height={25}
              borderRadius={15}
              fontSize={11}
              fontWeight={'600'}
              fontFamily={R.fonts.fontMedium}
              paddingHorizontal={15}
            />
          )}
          <View style={{flex: 0.1}}></View>
          <Button
            title="Chi tiết"
            onPress={() =>
              navigation.navigate(ScreenName.DETAILINCOMINGDOCUMENT)
            }
            backgroundColor={R.colors.blue}
            textColor={R.colors.white}
            height={25}
            width={90}
            borderRadius={15}
            fontSize={11}
            fontWeight={'600'}
            fontFamily={R.fonts.fontMedium}
            paddingHorizontal={15}
          />
        </View>
      </View>
    );
  };

  const renderListIncomingDocument = () => {
    return (
      <FlatList
        data={dataList}
        renderItem={renderItemIncomingDocument}
        keyExtractor={item => item.id.toString()}
        showsVerticalScrollIndicator={false}
      />
    );
  };

  return (
    <View style={styles.container}>
      <Header title={'Danh sách văn bản đến'} isBack />
      <View style={styles.body}>
        <View style={styles.cardTabView}>
          <FlatList
            data={dataListTabView}
            renderItem={itemTabView}
            keyExtractor={item => item.key}
            horizontal
            contentContainerStyle={styles.contentContainerStyle}
            showsHorizontalScrollIndicator={false}
          />
        </View>

        <View style={{marginBottom: 15}}>
          <View style={styles.card}>
            <TouchableOpacity style={styles.btnCard}>
              <Text
                style={[
                  styles.text,
                  {
                    color: R.colors.black,
                    fontSize: R.fontsize.fontSizeContent,
                    fontWeight: 600,
                    fontFamily: R.fonts.fontMedium,
                  },
                ]}>
                Học kỳ 2, Năm 2025
              </Text>
            </TouchableOpacity>
          </View>

          <View style={styles.box_3}>
            <View style={styles.searchBox}>
              <Image
                source={R.images.icSearch}
                style={{width: 20, height: 20}}
              />
              <View style={{flex: 1}}>
                <TextInput
                  placeholder="Tìm kiếm"
                  style={[styles.text, {padding: 0}]}
                  value={searchQuery}
                  onChangeText={setSearchQuery}
                />
              </View>
            </View>
            <View style={{flex: 0.1}}></View>

            <View style={styles.boxFilter}>
              <Dropdown title={'Tìm kiếm'} height={35} />
            </View>
          </View>
        </View>

        {renderListIncomingDocument()}
      </View>
    </View>
  );
};

export default IncomingDocumentView;
