import React from 'react';
import {View, Text, TouchableOpacity, ScrollView} from 'react-native';
import R from '../../../assets/R';
import styles from './style';

const FilterDayView = props => {
  const {
    currentDate,
    selectedDate,
    showMonthPicker,
    scrollViewRef,
    panResponder,
    getEventsForDate,
    getDayName,
    getMonthName,
    handleMonthSelect,
    toggleMonthPicker,
    calculateEventPosition,
    calculateEventLayout,
  } = props;

  const isToday = date => {
    const today = new Date();
    return (
      date.getDate() === today.getDate() &&
      date.getMonth() === today.getMonth() &&
      date.getFullYear() === today.getFullYear()
    );
  };
  const renderMonthPicker = () => {
    if (!showMonthPicker) return null;
  };

  const renderDateInfo = () => {
    return (
      <View style={{backgroundColor: R.colors.grayBorderInputTextHeader}}>
        <View style={styles.dateInfoContainer}>
          <Text style={styles.dayName}>{getDayName(selectedDate)}</Text>
          <Text
            style={
              isToday(selectedDate) ? styles.dayNumberToday : styles.dayNumber
            }>
            {selectedDate.getDate()}
          </Text>
        </View>
      </View>
    );
  };

  const renderTimeSlots = () => {
    const hours = Array.from({length: 24}, (_, i) => i);
    const selectedEvents = getEventsForDate(selectedDate);

    return (
      <View style={styles.timeSlotsContainer} {...panResponder.panHandlers}>
        <ScrollView
          ref={scrollViewRef}
          showsVerticalScrollIndicator={false}
          contentContainerStyle={styles.scrollContent}>
          <View style={styles.timelineContainer}>
            <View style={styles.timeLabelsColumn}>
              {hours.map(hour => {
                const timeStr = hour.toString().padStart(2, '0') + ':00';
                return (
                  <View key={hour} style={styles.timeSlot}>
                    <Text style={styles.timeText}>{timeStr}</Text>
                  </View>
                );
              })}
            </View>

            <View style={styles.eventsColumn}>
              {hours.map(hour => (
                <View key={hour} style={styles.gridLine} />
              ))}

              {calculateEventLayout(selectedEvents).map(event => {
                return (
                  <TouchableOpacity
                    key={event.id}
                    style={[
                      styles.eventCard,
                      {
                        position: 'absolute',
                        top: event.topPosition,
                        height: event.height,
                        left: event.leftOffset,
                        right: event.rightOffset,
                        zIndex: event.zIndex,
                        backgroundColor: R.colors.blue,
                        // Add minimum width to prevent events from being too narrow
                        minWidth: event.numColumns > 3 ? 60 : undefined,
                      },
                    ]}
                    activeOpacity={0.7}>
                    <Text
                      style={[
                        styles.eventTitle,
                        {
                          fontSize: event.numColumns > 2 ? 10 : event.numColumns > 1 ? 12 : 14,
                        }
                      ]}
                      numberOfLines={event.height > 60 ? 2 : 1}>
                      {event.title}
                    </Text>
                    {event.height > 40 && (
                      <Text 
                        style={[
                          styles.eventSubtitle,
                          {
                            fontSize: event.numColumns > 2 ? 9 : event.numColumns > 1 ? 11 : 13,
                          }
                        ]} 
                        numberOfLines={1}>
                        {event.subtitle}
                      </Text>
                    )}
                    <Text 
                      style={[
                        styles.eventTime,
                        {
                          fontSize: event.numColumns > 2 ? 8 : event.numColumns > 1 ? 10 : 12,
                        }
                      ]}>
                      {event.time} - {event.endTime}
                    </Text>
                  </TouchableOpacity>
                );
              })}
            </View>
          </View>
        </ScrollView>
      </View>
    );
  };
  return (
    <View style={styles.container}>
      {renderMonthPicker()}
      {renderDateInfo()}
      {renderTimeSlots()}
    </View>
  );
};

export default FilterDayView;
