import {StyleSheet, Text, TouchableOpacity, View} from 'react-native';
import React from 'react';
const RadioButton = ({
  selected,
  onPress,
  label,
  disable,
  size = 15,
  backgroundBoxColor,
  borderBoxColor,
  containerStyle,
  textColor = 'black',
  marginBtnAndLabel,
  containerMarginRight,
}) => {
  return (
    <TouchableOpacity
      onPress={disable ? undefined : onPress}
      style={[styles.containerRadioButton, containerStyle,{marginRight: containerMarginRight,}]}
      accessible={true} //Nhiệm vụ là báo cho hệ điều hành phần tử này và các phần tử con là một thành phần duy nhất
      accessibilityLabel={label || 'RadioButton'} //Nhãn dán
      accessibilityRole="button" //Xác định loại của phần tử
      accessibilityState={{
        selected,
        disabled: disable,
      }}>
      <View
        style={[
          styles.outerCircle,
          {
            width: size,
            height: size,
            borderColor: borderBoxColor,
            borderRadius: size / 2,
            opacity: disable ? 0.5 : 1,
            marginRight:marginBtnAndLabel,
          },
        ]}>
        {selected && (
          <View
            style={[
              styles.innerCircle,
              {
                width: size * 0.95,
                height: size * 0.95,
                borderRadius: (size * 0.95) / 2,
                backgroundColor: backgroundBoxColor,
              },
            ]}
          />
        )}
      </View>

      {label && (
        <Text
          style={[
            styles.textLabel,
            {color:textColor}
          ]}>
          {label}
        </Text>
      )}
    </TouchableOpacity>
  );
};

export default React.memo(RadioButton);

const styles = StyleSheet.create({
  containerRadioButton: {
    flexDirection: 'row',
    alignItems: 'center',
    
  },
  outerCircle: {
    width: 20,
    height: 20,
    borderWidth: 1,
    backgroundColor: 'white',
    borderRadius: 10,
    borderColor: 'black',
    alignItems: 'center',
    justifyContent: 'center',
  },
  innerCircle: {
    width: 10,
    height: 10,
    borderRadius: 5,
  },
  textLabel: {
    fontSize: 12,
  },
});
