import React, {useState} from 'react';
import AddWorkModalView from './view';

const AddWorkModal = ({visible, onClose, onSave}) => {
  const [formData, setFormData] = useState({
    title: '',
    content: '',
    category: null,
    responsible: null,
    deadline: null,
    assignee: null,
    implementer: null,
    attachments: [],
  });

  const [dataList, setDataList] = useState([
    {id: 1, name: 'Nguyễn Minh Đức'},
    {id: 2, name: 'Trần Văn Hùng'},
    {id: 3, name: 'Lê Thị Mai'},
    {id: 4, name: 'Phạm Quốc Khánh'},
    {id: 5, name: 'Hoàng Anh Tuấn'},
    {id: 6, name: 'Vũ Thị Hằng'},
    {id: 7, name: 'Ngô Văn Nam'},
    {id: 8, name: 'Đinh Thị Lan'},
    {id: 9, name: 'Bùi Văn Phúc'},
    {id: 10, name: 'Lý Thị Hoa'},
    {id: 11, name: 'Phan Minh Hoàng'},
    {id: 12, name: 'Tạ Thị Hương'},
    {id: 13, name: 'Đoàn Văn Dũng'},
    {id: 14, name: 'Nguyễn Thị Vân'},
    {id: 15, name: 'Trương Văn Long'},
    {id: 16, name: 'Mai Thị Ngọc'},
    {id: 17, name: 'Huỳnh Quốc Việt'},
    {id: 18, name: 'Lâm Thị Thu'},
    {id: 19, name: 'Nguyễn Hữu Tài'},
    {id: 20, name: 'Phạm Thị Kim'},
  ]);

  const categoryData = [
    {name: 'Công việc theo văn bản', value: 'document'},
    {name: 'Công việc khác', value: 'other'},
  ];

  const items = [
    {id: 1, label: 'Option 1'},
    {id: 2, label: 'Option 2'},
    {id: 3, label: 'Option 3'},
  ];

  const responsibleData = [
    {name: 'Công việc theo văn bản', value: 'document'},
    {name: 'Công việc cá nhân', value: 'personal'},
  ];

  const assigneeData = [
    {name: 'BM255, Nguyễn Minh Đức', value: 'duc'},
    {name: 'Khác', value: 'other'},
  ];

  const implementerData = [
    {name: 'BM255, Nguyễn Minh Đức', value: 'duc'},
    {name: 'Khác', value: 'other'},
  ];

  const updateFormData = (field, value) => {
    setFormData(prev => ({...prev, [field]: value}));
  };

  const handleSave = () => {
    onSave(formData);
    resetForm();
    onClose();
  };

  const resetForm = () => {
    setFormData({
      title: '',
      content: '',
      category: null,
      responsible: null,
      deadline: null,
      assignee: null,
      implementer: null,
      attachments: [],
    });
  };

  const handleCancel = () => {
    resetForm();
    onClose();
  };

  const handleItemPress = (item) => {
    // Logic xử lý khi nhấn vào item trong danh sách
    console.log('Item pressed:', item);
  };

  const handleDropdownSelect = (item, field) => {
    console.log('Dropdown selected:', item, field);
    updateFormData(field, item);
  };

  return (
    <AddWorkModalView
      visible={visible}
      formData={formData}
      dataList={dataList}
      categoryData={categoryData}
      items={items}
      responsibleData={responsibleData}
      assigneeData={assigneeData}
      implementerData={implementerData}
      updateFormData={updateFormData}
      handleSave={handleSave}
      handleCancel={handleCancel}
      handleItemPress={handleItemPress}
      handleDropdownSelect={handleDropdownSelect}
    />
  );
};

export default AddWorkModal;
