import React, {useState, useMemo} from 'react';
import {useNavigation} from '@react-navigation/native';
import ListWorkView from './view';
import * as ScreenName from '../../routers/ScreenNames';
import {WORK_PROGRESS, ROLE} from '../../actions/actionTypes';
import R from '../../assets/R';

const ListWork = props => {
  const navigation = useNavigation();
  const [searchQuery, setSearchQuery] = useState('');
  const [modalDeliverToMeVisible, setModalDeliverToMeVisible] = useState(false);
  const [modalMonitoringVisible, setModalMonitoringVisible] = useState(false);
  const [currentTabKey, setCurrentTabKey] = useState(ROLE.ALL);
  const [currentDropDownKey, setCurrentDropDownKey] = useState(
    WORK_PROGRESS.ALL_WORK_PROGRESS,
  );

  const [dataList, setDataList] = useState([
    {
      id: 1,
      title: 'Tạo thời khóa biểu cho sinh viên khai giảng và học kỳ 2 năm 2025',
      status: 'Đang thực hiện', // hợp lệ cho cả 2 role
      deadline: '2025-09-04',
      assignedToMe: true,
      supervisedByMe: false,
      supervisor: [
        {id: 1, name: 'Trần Văn Hùng'},
        {id: 2, name: 'Nguyễn Văn A'},
      ],
      document: 'BM255, Nguyễn Minh Đức',
      workProgress: 'Đang thực hiện',
    },
    {
      id: 2,
      title: 'Tạo thời khóa biểu cho sinh viên khai giảng và học kỳ 2 năm 2025',
      status: 'Cần chỉnh sửa', // chỉ hợp lệ với role Giao cho tôi
      deadline: '2025-09-04',
      assignedToMe: true,
      supervisedByMe: false,
      supervisor: [
        {id: 1, name: 'Trần Văn Hùng'},
        {id: 2, name: 'Nguyễn Văn A'},
      ],
      document: 'BM255, Nguyễn Minh Đức',
      workProgress: 'Đang hoàn thành',
    },
    {
      id: 3,
      title: 'Tạo thời khóa biểu cho sinh viên khai giảng và học kỳ 2 năm 2025',
      status: 'Hoàn thành', // hợp lệ cho cả 2 role
      deadline: '2025-09-04',
      assignedToMe: true,
      supervisedByMe: false,
      supervisor: [
        {id: 1, name: 'Trần Văn Hùng'},
        {id: 2, name: 'Nguyễn Văn A'},
      ],
      document: 'BM255, Nguyễn Minh Đức',
      workProgress: 'Đang hoàn thành',
    },
    {
      id: 4,
      title: 'Tạo thời khóa biểu cho sinh viên khai giảng và học kỳ 2 năm 2025',
      status: 'Đợi báo cáo', // chỉ hợp lệ với role Đang giám sát
      deadline: '2025-09-04',
      assignedToMe: false,
      supervisedByMe: true,
      supervisor: [
        {id: 1, name: 'Trần Văn Hùng'},
        {id: 2, name: 'Nguyễn Văn A'},
      ],
      document: 'BM255, Nguyễn Minh Đức',
      workProgress: 'Đang hoàn thành',
    },
    {
      id: 5,
      title: 'Tạo thời khóa biểu cho sinh viên khai giảng và học kỳ 2 năm 2025',
      status: 'Hoàn thành',
      deadline: '2025-09-04',
      assignedToMe: false,
      supervisedByMe: true,
      supervisor: [
        {id: 1, name: 'Trần Văn Hùng'},
        {id: 2, name: 'Nguyễn Văn A'},
      ],
      document:
        'Văn bản thông báo lịch nộp thời khóa biểu của học kỳ 2 năm 2025',
      workProgress: 'Đang thực hiện',
    },
    {
      id: 6,
      title: 'Cập nhật đề cương môn CSDL nâng cao',
      status: 'Đang thực hiện',
      deadline: '2025-09-10',
      assignedToMe: true,
      supervisedByMe: false,
      supervisor: [
        {id: 1, name: 'Trần Văn Hùng'},
        {id: 2, name: 'Nguyễn Văn A'},
      ],
      document: 'BM301, Phòng Đào tạo',
      workProgress: 'Đang thực hiện',
    },
    {
      id: 7,
      title: 'Bổ sung tài liệu tham khảo môn Mạng máy tính',
      status: 'Cần chỉnh sửa',
      deadline: '2025-09-12',
      assignedToMe: true,
      supervisedByMe: false,
      supervisor: [
        {id: 1, name: 'Trần Văn Hùng'},
        {id: 2, name: 'Nguyễn Văn A'},
      ],
      document: 'Công văn 12/MN',
      workProgress: 'Đã hoàn thành',
    },
    {
      id: 8,
      title: 'Chuẩn bị lịch thi giữa kỳ Khoa CNTT',
      status: 'Đợi báo cáo',
      deadline: '2025-09-15',
      assignedToMe: true,
      supervisedByMe: false,
      supervisor: [
        {id: 1, name: 'Trần Văn Hùng'},
        {id: 2, name: 'Nguyễn Văn A'},
      ],
      document: 'BM-Exam-2025',
      workProgress: 'Đã hoàn thành',
    },
    {
      id: 9,
      title: 'Rà soát nội dung slide môn Lập trình di động',
      status: 'Chờ duyệt',
      deadline: '2025-09-11',
      assignedToMe: true,
      supervisedByMe: false,
      supervisor: [
        {id: 1, name: 'Trần Văn Hùng'},
        {id: 2, name: 'Nguyễn Văn A'},
      ],
      document: 'Slide_v2.pptx',
      workProgress: 'Đã hoàn thành',
    },
    {
      id: 10,
      title: 'Hoàn thiện đề cương môn AI ứng dụng',
      status: 'Hoàn thành',
      deadline: '2025-09-05',
      assignedToMe: true,
      supervisedByMe: false,
      supervisor: [
        {id: 1, name: 'Trần Văn Hùng'},
        {id: 2, name: 'Nguyễn Văn A'},
      ],
      document: 'AI-Syllabus-Final.pdf',
      workProgress: 'Đang thực hiện',
    },
    {
      id: 11,
      title: 'Theo dõi tiến độ cập nhật website khoa',
      status: 'Đang thực hiện',
      deadline: '2025-09-18',
      assignedToMe: false,
      supervisedByMe: true,
      supervisor: [
        {id: 1, name: 'Trần Văn Hùng'},
        {id: 2, name: 'Nguyễn Văn A'},
      ],
      document: 'Biên bản họp 09/2025',
      workProgress: 'Đang thực hiện',
    },
    {
      id: 12,
      title: 'Yêu cầu chỉnh sửa báo cáo đề tài nghiên cứu',
      status: 'Đợi chỉnh sửa',
      deadline: '2025-09-20',
      assignedToMe: false,
      supervisedByMe: true,
      supervisor: [
        {id: 1, name: 'Trần Văn Hùng'},
        {id: 2, name: 'Nguyễn Văn A'},
      ],
      document: 'Report-Draft.docx',
      workProgress: 'Đã hoàn thành',
    },
    {
      id: 13,
      title: 'Giám sát thu thập minh chứng kiểm định',
      status: 'Đợi báo cáo',
      deadline: '2025-09-22',
      assignedToMe: false,
      supervisedByMe: true,
      supervisor: [
        {id: 1, name: 'Trần Văn Hùng'},
        {id: 2, name: 'Nguyễn Văn A'},
      ],
      document: 'Checklist-KDCL.xlsx',
      workProgress: 'Đã hoàn thành',
    },
    {
      id: 14,
      title: 'Phê duyệt lịch seminar học kỳ 1',
      status: 'Chờ duyệt',
      deadline: '2025-09-13',
      assignedToMe: false,
      supervisedByMe: true,
      supervisor: [
        {id: 1, name: 'Trần Văn Hùng'},
        {id: 2, name: 'Nguyễn Văn A'},
      ],
      document: 'SeminarPlan.docx',
      workProgress: 'Đang thực hiện',
    },
    {
      id: 15,
      title: 'Nghiệm thu giáo trình Nhập môn CNTT',
      status: 'Hoàn thành',
      deadline: '2025-09-03',
      assignedToMe: false,
      supervisedByMe: true,
      supervisor: [
        {id: 1, name: 'Trần Văn Hùng'},
        {id: 2, name: 'Nguyễn Văn A'},
      ],
      document: 'Textbook-Final.pdf',
      workProgress: 'Đã hoàn thành',
    },
    {
      id: 16,
      title: 'Soạn đề bài lab React Native tuần 3',
      status: 'Đang thực hiện',
      deadline: '2025-09-16',
      assignedToMe: true,
      supervisedByMe: false,
      supervisor: [
        {id: 1, name: 'Trần Văn Hùng'},
        {id: 2, name: 'Nguyễn Văn A'},
      ],
      document: 'RN-Lab3.md',
      workProgress: 'Đang thực hiện',
    },
    {
      id: 17,
      title: 'Sửa lỗi bài tập lớn nhóm 2',
      status: 'Cần chỉnh sửa',
      deadline: '2025-09-17',
      assignedToMe: true,
      supervisedByMe: false,
      supervisor: [
        {id: 1, name: 'Trần Văn Hùng'},
        {id: 2, name: 'Nguyễn Văn A'},
      ],
      document: 'Issue#127',
      workProgress: 'Đang thực hiện',
    },
    {
      id: 18,
      title: 'Giám sát cập nhật slide môn Big Data',
      status: 'Đợi chỉnh sửa',
      deadline: '2025-09-19',
      assignedToMe: false,
      supervisedByMe: true,
      supervisor: [
        {id: 1, name: 'Trần Văn Hùng'},
        {id: 2, name: 'Nguyễn Văn A'},
      ],
      document: 'BigData-Slides-v1.pptx',
      workProgress: 'Đang thực hiện',
    },
    {
      id: 19,
      title: 'Hoàn thiện biên bản họp tổ bộ môn',
      status: 'Đợi báo cáo',
      deadline: '2025-09-14',
      assignedToMe: true,
      supervisedByMe: false,
      supervisor: [
        {id: 1, name: 'Trần Văn Hùng'},
        {id: 2, name: 'Nguyễn Văn A'},
      ],
      document: 'Minutes-Dept-0909.docx',
      workProgress: 'Đang thực hiện',
    },
    {
      id: 20,
      title: 'Xét duyệt danh sách đồ án tốt nghiệp',
      status: 'Chờ duyệt',
      deadline: '2025-09-21',
      assignedToMe: false,
      supervisedByMe: true,
      supervisor: [
        {id: 1, name: 'Trần Văn Hùng'},
        {id: 2, name: 'Nguyễn Văn A'},
      ],
      document: 'Thesis-List.xlsx',
      workProgress: 'Chờ duyệt',
    },
  ]);

  // ==================== MODAL HANDLERS ====================

  // Mở modal thêm công việc mới
  const handleAddWork = () => {
    if (currentTabKey === ROLE.ASSIGNEE) {
      setModalDeliverToMeVisible(true);
    } else if (currentTabKey === ROLE.SUPERVISOR) {
      setModalMonitoringVisible(true);
    }
  };

  // Đóng modal "Giao cho tôi"
  const handleCloseDeliverToMeModal = () => {
    setModalDeliverToMeVisible(false);
  };

  // Đóng modal "Đang giám sát"
  const handleCloseMonitoringModal = () => {
    setModalMonitoringVisible(false);
  };

  // Xử lý lưu công việc "Giao cho tôi"
  const handleSaveDeliverToMeWork = workData => {
    console.log('Đang lưu công việc giao cho tôi:', workData);
    // TODO: Thêm logic lưu công việc giao cho tôi vào database
    setModalDeliverToMeVisible(false);
  };

  // Xử lý lưu công việc "Đang giám sát"
  const handleSaveMonitoringWork = workData => {
    console.log('Đang lưu công việc giám sát:', workData);
    // TODO: Thêm logic lưu công việc giám sát vào database
    setModalMonitoringVisible(false);
  };

  // ==================== FILTER & SEARCH HANDLERS ====================

  // Xử lý thay đổi bộ lọc tab
  const handleFilterChange = item => {
    setCurrentTabKey(item?.key || ROLE.ALL);
    console.log('Tab changed to:', item?.key);
  };
  // Hiển thị dữ liệu sau khi chọn
  const filterList = useMemo(() => {
    let base = dataList;

    // Lọc theo tab role
    if (currentTabKey === ROLE.ASSIGNEE) {
      base = base.filter(x => x.assignedToMe);
    } else if (currentTabKey === ROLE.SUPERVISOR) {
      base = base.filter(x => x.supervisedByMe);
    }
    // ROLE.ALL không cần filter

    // Lọc theo search query
    if (searchQuery && searchQuery.trim()) {
      const q = searchQuery.trim().toLowerCase();
      base = base.filter(
        x =>
          x.title.toLowerCase().includes(q) ||
          x.status.toLowerCase().includes(q),
      );
    }

    // Lọc theo dropdown progress (chỉ khi không phải ALL)
    if (currentDropDownKey === WORK_PROGRESS.SUCCESS_WORK_PROGRESS) {
      base = base.filter(x => x.status === 'Đã hoàn thành');
    } else if (currentDropDownKey === WORK_PROGRESS.CONTINUE_WORK_PROGRESS) {
      base = base.filter(x => x.status !== 'Đã hoàn thành');
    }
    // WORK_PROGRESS.ALL_WORK_PROGRESS không cần filter

    return base;
  }, [dataList, currentTabKey, searchQuery, currentDropDownKey]);

  // ==================== NAVIGATION HANDLERS ====================

  // Điều hướng đến màn hình chi tiết công việc - conditional navigation
  const handleViewDetailWork = item => {
    // Nếu công việc được giao cho tôi (assignedToMe: true) -> đi vào màn hình detail như cũ
    if (item.assignedToMe) {
      navigation.navigate(ScreenName.DETAILWORKDELIVERTOME, {workItem: item});
    }
    // Nếu tôi đang giám sát công việc này (supervisedByMe: true) -> đi vào màn hình monitoring
    else if (item.supervisedByMe) {
      navigation.navigate(ScreenName.DETAILWORKMONITORING, {workItem: item});
    }
  };

  // Giữ lại function cũ để tương thích
  const handleViewDetailDeliverToMe = item => {
    handleViewDetailWork(item);
  };

  // ==================== ACTION HANDLERS ====================

  // Xử lý các hành động báo cáo (báo cáo, yêu cầu báo cáo)
  const handleReportAction = (item, action) => {
    console.log(`Thực hiện hành động ${action} cho công việc:`, item.id);
    // TODO: Thêm logic xử lý các hành động báo cáo
    switch (action) {
      case 'report':
        // Xử lý báo cáo công việc
        break;
      default:
        break;
    }
  };

  // Xử lý các hành động phê duyệt (phê duyệt, yêu cầu chỉnh sửa)
  const handleApprovalAction = (item, action) => {
    console.log(`Thực hiện hành động ${action} cho công việc:`, item.id);
    // TODO: Thêm logic xử lý phê duyệt
    switch (action) {
      case 'approve':
        // Xử lý phê duyệt công việc
        break;
      case 'needsEdit':
        // Xử lý yêu cầu chỉnh sửa
        break;
      default:
        break;
    }
  };

  // ==================== UTILITY FUNCTIONS ====================

  // Lấy màu sắc theo trạng thái công việc
  const getStatusColor = status => {
    switch (status) {
      case 'Đang thực hiện':
        return '#FF9500'; // Cam
      case 'Chờ duyệt':
        return '#007AFF'; // Xanh dương
      case 'Cần chỉnh sửa':
        return '#FF9500'; // Cam (assignee)
      case 'Đợi chỉnh sửa':
        return '#FF9500'; // Cam (supervisor)
      case 'Hoàn thành':
        return '#34C759'; // Xanh lá
      case 'Đợi báo cáo':
        return '#007AFF'; // Xanh dương
      default:
        return '#8E8E93'; // Xám
    }
  };

  // Lấy danh sách button theo trạng thái công việc
  const getButtonsForStatus = (status, workItem) => {
    // Đang giám sát
    if (currentTabKey === ROLE.SUPERVISOR) {
      return getButtonsForSupervisor(status);
    }

    // Giao cho tôi
    if (currentTabKey === ROLE.ASSIGNEE) {
      return getButtonsForAssignee(status);
    }

    // Tất cả - hiển thị buttons theo role của từng công việc
    if (currentTabKey === ROLE.ALL) {
      // Nếu công việc được giao cho tôi
      if (workItem.assignedToMe) {
        return getButtonsForAssignee(status);
      }
      // Nếu tôi đang giám sát công việc này
      if (workItem.supervisedByMe) {
        return getButtonsForSupervisor(status);
      }
    }

    return [
      {title: 'Chi tiết', backgroundColor: R.colors.blue, action: 'detail'},
    ];
  };

  // Helper function cho buttons của Supervisor
  const getButtonsForSupervisor = status => {
    switch (status) {
      case 'Đang thực hiện':
        // Supervisor có thể yêu cầu báo cáo từ người được giao việc
        return [
          {
            title: 'Yêu cầu báo cáo',
            backgroundColor: R.colors.orange,
            action: 'requestReport',
          },
          {title: 'Chi tiết', backgroundColor: R.colors.blue, action: 'detail'},
        ];
      case 'Đợi chỉnh sửa':
        // Đang chờ người được giao việc chỉnh sửa
        return [
          {title: 'Chi tiết', backgroundColor: R.colors.blue, action: 'detail'},
        ];
      case 'Chờ duyệt':
        // Supervisor cần phê duyệt hoặc yêu cầu chỉnh sửa
        return [
          {
            title: 'Cần chỉnh sửa',
            backgroundColor: R.colors.orange,
            action: 'needsEdit',
          },
          {
            title: 'Phê duyệt',
            backgroundColor: R.colors.green,
            action: 'approve',
          },
          {title: 'Chi tiết', backgroundColor: R.colors.blue, action: 'detail'},
        ];
      case 'Đợi báo cáo':
        // Đang chờ người được giao việc nộp báo cáo
        return [
          {title: 'Chi tiết', backgroundColor: R.colors.blue, action: 'detail'},
        ];
      case 'Hoàn thành':
        return [
          {title: 'Chi tiết', backgroundColor: R.colors.blue, action: 'detail'},
        ];
      default:
        return [];
    }
  };

  // Helper function cho buttons của Assignee
  const getButtonsForAssignee = status => {
    switch (status) {
      case 'Đang thực hiện':
        // Người được giao việc đang thực hiện và có thể nộp báo cáo
        return [
          {
            title: 'Báo cáo',
            backgroundColor: R.colors.orange,
            action: 'report',
          },
          {title: 'Chi tiết', backgroundColor: R.colors.blue, action: 'detail'},
        ];
      case 'Cần chỉnh sửa':
        // Supervisor yêu cầu chỉnh sửa, người được giao việc cần báo cáo lại
        return [
          {
            title: 'Báo cáo',
            backgroundColor: R.colors.orange,
            action: 'report',
          },
          {title: 'Chi tiết', backgroundColor: R.colors.blue, action: 'detail'},
        ];
      case 'Đợi báo cáo':
        // Supervisor yêu cầu báo cáo, người được giao việc cần nộp báo cáo
        return [
          {
            title: 'Báo cáo',
            backgroundColor: R.colors.orange,
            action: 'report',
          },
          {title: 'Chi tiết', backgroundColor: R.colors.blue, action: 'detail'},
        ];
      case 'Chờ duyệt':
        // Đã nộp báo cáo, đang chờ supervisor duyệt, có thể sửa báo cáo
        return [
          {
            title: 'Sửa báo cáo',
            backgroundColor: R.colors.orange,
            action: 'editReport',
          },
          {title: 'Chi tiết', backgroundColor: R.colors.blue, action: 'detail'},
        ];
      case 'Hoàn thành':
        return [
          {title: 'Chi tiết', backgroundColor: R.colors.blue, action: 'detail'},
        ];
      default:
        return [];
    }
  };

  const [tabView, setTabView] = useState([
    {key: ROLE.ALL, label: 'Tất cả'},
    {key: ROLE.ASSIGNEE, label: 'Giao cho tôi'},
    {key: ROLE.SUPERVISOR, label: 'Đang giám sát'},
  ]);

  // Kiểm tra có hiển thị FAB hay không
  const shouldShowFAB = () => {
    return currentTabKey !== ROLE.ALL;
  };

  // ==================== RENDER ====================

  return (
    <ListWorkView
      // Dữ liệu
      searchQuery={searchQuery}
      setSearchQuery={setSearchQuery}
      dataList={filterList}
      modalDeliverToMeVisible={modalDeliverToMeVisible}
      modalMonitoringVisible={modalMonitoringVisible}
      tabView={tabView}
      currentTabKey={currentTabKey}
      shouldShowFAB={shouldShowFAB()}
      // Sự kiện
      onFilterChange={handleFilterChange}
      onAddWork={handleAddWork}
      onSaveDeliverToMeWork={handleSaveDeliverToMeWork}
      onSaveMonitoringWork={handleSaveMonitoringWork}
      onCloseDeliverToMeModal={handleCloseDeliverToMeModal}
      onCloseMonitoringModal={handleCloseMonitoringModal}
      onViewDetailDeliverToMe={handleViewDetailDeliverToMe}
      onReportAction={handleReportAction}
      onApprovalAction={handleApprovalAction}
      // Utils
      getStatusColor={getStatusColor}
      getButtonsForStatus={getButtonsForStatus}
    />
  );
};

export default ListWork;
