import React from 'react';
import {
  Text,
  View,
  FlatList,
  ScrollView,
} from 'react-native';
import styles from './style';
import Header from '../../../components/Header/Header';
import R from '../../../assets/R';
const DetailFeedBackView = props => {
  const {teacher, dataListQuestion} = props;

  const renderTableRow = (item, index) => {
    return (
      <View key={item.id} style={styles.tableRow}>
        <View style={styles.tableCellSmall}>
          <Text style={styles.tableCellText}>{item.id}</Text>
        </View>
        <View style={styles.tableCell}>
          <Text style={styles.tableCellText}>{item.Q1}</Text>
        </View>
        <View style={styles.tableCell}>
          <Text style={styles.tableCellText}>{item.Q2}</Text>
        </View>
        <View style={styles.tableCell}>
          <Text style={styles.tableCellText}>{item.Q3}</Text>
        </View>
        <View style={styles.tableCell}>
          <Text style={styles.tableCellText}>{item.Q4}</Text>
        </View>
        <View style={styles.tableCell}>
          <Text style={styles.tableCellText}>{item.GPA}</Text>
        </View>
        <View style={styles.tableCell}>
          <Text style={styles.tableCellText}>{item.comment}</Text>
        </View>
      </View>
    );
  };

  const renderItem = ({item}) => {
    return (
      <View style={styles.boxFeedBack}>
        <Text
          style={[
            styles.textSubTitle,
            {
              fontFamily: R.fonts.fontRegular,
              fontWeight: '400',
              color: R.colors.black,
            },
          ]}>
          Q{item.id}: {item.question}
        </Text>
      </View>
    );
  };

  const renderBodyHeader = () => {
    return (
      <View>
        <Text style={styles.textSubTitle}>
          Feedback của sinh viên lớp {teacher.class} môn {teacher.subject} đối
          với giảng viên {teacher.teacher}.
        </Text>
        <View style={styles.containerQuestion}>
          <FlatList
            nestedScrollEnabled
            data={dataListQuestion?.question || []}
            renderItem={renderItem}
            keyExtractor={item => item.id.toString()}
            showsVerticalScrollIndicator={false}
            vertical
          />
        </View>
      </View>
    );
  };

  const renderTable = () => {
    return (
      <ScrollView
        showsVerticalScrollIndicator={false}
        style={styles.tableContainer}>
        <View style={styles.tableRow}>
          <View style={styles.tableHeaderCellSmall}>
            <Text style={styles.tableHeaderText}>#</Text>
          </View>
          <View style={styles.tableHeaderCell}>
            <Text style={styles.tableHeaderText}>Q1</Text>
          </View>
          <View style={styles.tableHeaderCell}>
            <Text style={styles.tableHeaderText}>Q2</Text>
          </View>
          <View style={styles.tableHeaderCell}>
            <Text style={styles.tableHeaderText}>Q3</Text>
          </View>
          <View style={styles.tableHeaderCell}>
            <Text style={styles.tableHeaderText}>Q4</Text>
          </View>
          <View style={styles.tableHeaderCell}>
            <Text style={styles.tableHeaderText}>GPA</Text>
          </View>
          <View style={styles.tableHeaderCell}>
            <Text style={styles.tableHeaderText}>N.Xét</Text>
          </View>
        </View>

        {dataListQuestion?.results?.map((item, index) =>
          renderTableRow(item, index),
        )}
      </ScrollView>
    );
  };

  return (
    <View style={styles.container}>
      <Header title={'Đánh giá giảng dạy'} isBack />
      <View style={styles.body}>
        {renderBodyHeader()}
        {renderTable()}
      </View>
    </View>
  );
};

export default DetailFeedBackView;
