import React, {useState} from 'react';
import {
    View,
    TouchableOpacity,
    Text,
    LayoutAnimation,
    StyleSheet
} from 'react-native';
import R from '../../../../../../assets/R';

import Ionicons from 'react-native-vector-icons/Ionicons';
import {getFontXD, getLineHeightXD, HEIGHTXD, WIDTHXD} from '../../../../../../Config/Functions';
import I18n from '../../../../../../helper/i18/i18n';
import TextField from '../../../../../../components/TextField';

const GeneralInfo = (props) => {
    const [expanded, setExpanded] = useState(true);
    const changeLayout = () => {
        LayoutAnimation.configureNext({
            duration: 500,
            create: {
                type: LayoutAnimation.Types.spring,
                property: LayoutAnimation.Properties.scaleY,
                springDamping: 1.7,
            },
            update: {
                type: LayoutAnimation.Types.spring,
                springDamping: 1.7,
            },
        });
        setExpanded(!expanded)
    };

    return (
        <View style={styles.container}>
            <TouchableOpacity
                onPress={() => changeLayout()}
                style={[styles.flexTitle, { borderBottomWidth: expanded === true ? 0.3 : 0, paddingHorizontal: WIDTHXD(30) }]}
            >
                <Text style={styles.title}>{I18n.t('TimeTransaction')}</Text>
                {expanded === true ? (
                    <Ionicons
                        name='chevron-up'
                        size={WIDTHXD(50)}
                        style={{ marginRight: WIDTHXD(50) }}
                        color={R.colors.iconGray}
                    />
                ) : (
                    <Ionicons
                        name='chevron-down'
                        size={WIDTHXD(50)}
                        style={{ marginRight: WIDTHXD(50) }}
                        color={R.colors.iconGray}
                    />
                )}
            </TouchableOpacity>
            {expanded ?
                <View style={{paddingVertical: HEIGHTXD(20)}}>
                    <TextField
                        title={I18n.t('Time')}
                        content={'Thứ 2 - Thứ 6'}
                    />
                    <TextField
                        title={I18n.t('TransactionSession')}
                        content={'Phiên 1 07:00 - 19:45 \nPhiên 2: 20:30 - 01:45 (ngày hôm sau)'}
                    />
                    <TextField
                        title={I18n.t('MaturityMonth')}
                        content={'Tháng 3, 5, 7, 9'}
                    />
                    <TextField
                        title={I18n.t('RegisteredDeliveryDate')}
                        content={'Ngày làm việc thứ 5 trước ngày thông báo đầu tiên'}
                    />
                    <TextField
                        title={I18n.t('FirstNotifyDate')}
                        content={'Ngày làm việc cuối cùng của tháng liên trước tháng đáo hạn'}
                    />
                    <TextField
                        title={I18n.t('EndlessTransactionDate')}
                        content={'Ngày làm việc trước ngày 15 của tháng đáo hạn'}
                    />
                </View>
                : null
            }
        </View>
    )

}
export default GeneralInfo
const styles = StyleSheet.create({
    container: {
        backgroundColor: R.colors.white,
        width: '100%',
        shadowColor: '#181F4D21',
        shadowOffset: {width: 1, height: 1},
        shadowOpacity: 1,
        shadowRadius: 2,
        elevation: 1,
        marginVertical: HEIGHTXD(30)
    },
    flexTitle: {
        flexDirection: 'row',
        alignItems: 'center',
        justifyContent: 'space-between',
        paddingVertical: HEIGHTXD(36),
        borderBottomColor: R.colors.borderGray,
    },
    title: {
        fontSize: getFontXD(36),
        lineHeight: getLineHeightXD(56),
        color: R.colors.main,
        textTransform: 'uppercase',
    },
})
