import React from 'react';
import {
  View,
  Text,
  StyleSheet,
  TouchableOpacity,
  Image,
  Alert,
} from 'react-native';
import {
  getFontXD,
  HEIGHTXD,
  WIDTHXD,
  toPriceVnd,
} from '../../../Config/Functions';
import R from '../../../assets/R';
import Block from '../../../components/Block';

const Item = (props) => {
  const {item, isEndItem} = props;
  return (
    <View style={[styles.container, isEndItem && {marginBottom: HEIGHTXD(100)}]}>
      <TouchableOpacity onPress={() => props.onPress(item)}>
        <Block flex={1} row>
            <Image source={R.images.iconRecharge} style={styles.imgIcon} />
          <Block padding={[0, WIDTHXD(40)]} space={'between'} flex={1}>
            <View
              style={{
                flex: 1,
                flexDirection: 'row',
                justifyContent: 'space-between',
              }}>
              <Text numberOfLines={2} style={[styles.txtBlack, {flexWrap: 'wrap', flex: 1}]} numberOfLines={1} ellipsizeMode='tail'>
                {item.name}
              </Text>
              <Text style={styles.txtMoney}>{toPriceVnd(item.fee)}</Text>
            </View>
            <Text style={styles.txt}>{item.code}</Text>
          </Block>
        </Block>
      </TouchableOpacity>
    </View>
  );
};

export default Item;

const styles = StyleSheet.create({
  container: {
    paddingVertical: HEIGHTXD(40),
    shadowColor: '#000',
    shadowOffset: {
      width: 0,
      height: 2,
    },
    shadowOpacity: 0.25,
    shadowRadius: 3.84,
    elevation: 5,
    backgroundColor: R.colors.white,
    borderRadius: HEIGHTXD(30),
    marginVertical: HEIGHTXD(15),
    marginHorizontal: WIDTHXD(30)
  },

  wrapLeft: {
    width: WIDTHXD(16),
    borderTopLeftRadius: HEIGHTXD(30),
    borderBottomStartRadius: HEIGHTXD(30),
  },
  txtTitle: {
    fontSize: getFontXD(42),
    color: R.colors.black,
    fontWeight: 'bold',
  },
  txt: {
    fontSize: getFontXD(36),
    color: 'black',
  },
  rowBet: {
    flexDirection: 'row',
    justifyContent: 'space-between',
    alignItems: 'center',
  },
  txtBlack: {
    fontSize: getFontXD(50),
    color: 'black',
  },
  imgIcon: {
    width: WIDTHXD(150),
    height: HEIGHTXD(150),
    resizeMode: 'contain',
    marginLeft: WIDTHXD(35)
  },
  txtMoney: {
    fontSize: getFontXD(42),
    color: R.colors.main,
  },
});
