import React, {useState, useEffect} from 'react';
import {
    View,
    Text,
    StyleSheet,
    FlatList,
    Dimensions,
    TouchableOpacity,
    Alert,
    KeyboardAvoidingView,
    TouchableWithoutFeedback,
    Keyboard,
    Platform,
} from 'react-native';
import {connect} from 'react-redux';
import R from '../../assets/R';
import HeaderBack from '../../components/Header/HeaderBack';
import I18n from '../../helper/i18/i18n';

import Item from './Item';
import {getFontXD, WIDTHXD, checkFormatArray} from '../../Config/Functions';
import TextField from '../../components/Input/TextField';
import PickerItem from '../../components/Picker/PickerItem';
import {
    deleteMethodBank,
    addMethodBank,
    updateMethodBank,
} from '../../apis/Functions/Widthdraw';
import {showLoading, hideLoading} from '../../actions/loadingAction';
import {useNavigation} from '@react-navigation/native';
import BankInfor from '../../components/BankInfor';
import AppText from '../../components/AppText';

const {width} = Dimensions.get('window');

const MethodPayDetail = (props) => {
    const [data, setData] = useState([]);
    const {params} = props.route;

    const [disable, setDisable] = useState(true);
    const navigate = useNavigation();
    const [branch_name, setBankName] = useState(params.branch_name);
    const [account_name, setAccountName] = useState(params.account_name);
    const [account_no, setAccountNo] = useState(params.account_no);

    const onUpdate = async () => {
        const titles = [
            I18n.t('Branch').toLowerCase(),
            I18n.t('OwnerAccount2').toLowerCase(),
            I18n.t('AccountNumber').toLowerCase()
        ];
        const index = checkFormatArray([branch_name, account_name, account_no]);
        if (index === true) {
            if (
                branch_name != params.branch_name ||
                account_name != params.account_name ||
                account_no != params.account_no
            ) {
                props.showLoading();
                const res = await updateMethodBank({
                    platform: Platform.OS,
                    id: params.id,
                    branch_name,
                    account_name,
                    account_no,
                });
                props.hideLoading();
                if (res.data.code == 200) {
                    setTimeout(() => {
                        Alert.alert(I18n.t('Notification'), res.data.message);
                        navigate.goBack();
                    }, 500);
                } else {
                    setTimeout(() => {
                        Alert.alert(I18n.t('Notification'), res.data.message);
                    }, 500);
                }
            } else {
                Alert.alert(I18n.t('Notification'), I18n.t('NothingChange'));
            }
        } else {
            Alert.alert(
                I18n.t('Notification'),
                I18n.t('Please_fill_in') + titles[index],
            );
        }
    };

    const onRemove = async () => {
        props.showLoading();
        const res = await deleteMethodBank({
            platform: Platform.OS,
            id: params.id,
        });
        props.hideLoading();
        if (res.data.code == 200) {
            setTimeout(() => {
                Alert.alert(I18n.t('Notification'), res.data.message);
                navigate.goBack();
            }, 500);
        } else {
            setTimeout(() => {
                Alert.alert(I18n.t('Notification'), res.data.message);
            }, 500);
        }
    };

    return (
        <KeyboardAvoidingView
            behavior={Platform.Os === 'ios' ? 'padding' : 'height'}
            style={{flex: 1}}
            keyboardVerticalOffset={-50}>
            <TouchableWithoutFeedback onPress={Keyboard.dismiss}>
                <View style={{flex: 1}}>
                    <HeaderBack title={'DetailMethod'}/>
                    <View style={{flex: 1}}>
                        <View style={styles.container}>
                            <BankInfor
                                linkImg={params.bank.logo}
                                title={I18n.t('SelectBank')}
                                value={params.bank.name}
                            />
                            <TextField
                                onChangeText={(val) => setBankName(val)}
                                title={I18n.t('Branch')}
                                value={branch_name}
                            />

                            <TextField
                                onChangeText={(val) => setAccountName(val)}
                                title={I18n.t('OwnerAccountName')}
                                value={account_name}
                            />
                            <TextField
                                onChangeText={(val) => setAccountNo(val)}
                                title={I18n.t('AccountNumber')}
                                isNumber={true}
                                value={account_no}
                            />
                        </View>
                    </View>
                    <View style={styles.footer}>
                        <TouchableOpacity onPress={onUpdate} style={styles.btnLeft}>
                            <AppText style={styles.txtAdd} i18nKey={('Update')}/>
                        </TouchableOpacity>
                        <TouchableOpacity
                            onPress={() => {
                                Alert.alert(
                                    `${I18n.t('Notification')}!`,
                                    I18n.t('DeletePaymentMethodConfirm'),
                                        [
                                        {
                                            text: I18n.t('Forbidden'),
                                            style: 'cancel',
                                        },
                                            {text: I18n.t('Ok'), onPress: () => onRemove()},
                                        ],
                                );
                            }}
                            style={styles.btnRight}>
                            <AppText style={styles.txtAdd} i18nKey={('Delete')}/>
                        </TouchableOpacity>
                    </View>
                </View>
            </TouchableWithoutFeedback>
        </KeyboardAvoidingView>
    );
};

const styles = StyleSheet.create({
    container: {
        paddingHorizontal: 20,
        paddingTop: 10,
    },
    footer: {
        flexDirection: 'row',
        alignItems: 'center',
        justifyContent: 'space-between',
        marginBottom: 10,
        paddingHorizontal: 20,
    },
    btnLeft: {
        width: 150,
        height: 40,
        justifyContent: 'center',
        alignItems: 'center',
        backgroundColor: R.colors.main,
        borderRadius: 5,
    },
    btnRight: {
        width: 150,
        height: 40,
        justifyContent: 'center',
        alignItems: 'center',
        backgroundColor: R.colors.main,
        borderRadius: 5,
    },
    txtAdd: {
        color: R.colors.white,
        fontSize: getFontXD(46),
        textTransform: 'uppercase',
        fontWeight: 'bold',
    },
    txtTitle: {
        fontSize: getFontXD(42),
        color: R.colors.color777,
        marginBottom: 5,
    },
});

const mapStateToProps = (state) => {
    return {
        user: state.userReducer,
    };
};
export default connect(mapStateToProps, {
    showLoading,
    hideLoading,
})(MethodPayDetail);
