import React, {useState, useEffect} from 'react';
import {
  View,
  Text,
  StyleSheet,
  FlatList,
  Dimensions,
  TouchableOpacity,
  Alert,
  ScrollView,
  KeyboardAvoidingView,
  Platform,
  TouchableWithoutFeedback,
  Keyboard,
} from 'react-native';
import {connect} from 'react-redux';
import R from '../../assets/R';
import HeaderBack from '../../components/Header/HeaderBack';

import Item from './Item';
import {getFontXD, WIDTHXD, checkFormatArray} from '../../Config/Functions';
import TextField from '../../components/Input/TextField';
import PickerItem from '../../components/Picker/PickerItem';
import {getListBank, addMethodBank} from '../../apis/Functions/Widthdraw';
import {showLoading, hideLoading} from '../../actions/loadingAction';
import {useNavigation} from '@react-navigation/native';
import I18n from '../../helper/i18/i18n';
import SelectBankModal from './SelectBankModal';

const {width} = Dimensions.get('window');

const AddMethodPay = (props) => {
  const [data, setData] = useState([]);
  const navigate = useNavigation();

  const [bank_id, setBankID] = useState();
  const [branch_name, setBankName] = useState();
  const [account_name, setAccountName] = useState();
  const [account_no, setAccountNo] = useState();

  useEffect(() => {
    getData();
  }, []);

  const getData = async () => {
    const res = await getListBank({
      platform: Platform.OS,
    });
    if (res.data.code == 200 && res.data.data) {
      setData(res.data.data);
    } else {
      Alert.alert(I18n.t('Notification'), I18n.t('Can_not_get_data'));
    }
  };

  const onLick = async () => {
    const titles = [
      I18n.t('Bank').toLowerCase(),
      I18n.t('Branch').toLowerCase(),
      I18n.t('OwnerAccount2').toLowerCase(),
      I18n.t('AccountNumber').toLowerCase(),
    ];
    const index = checkFormatArray([
      bank_id,
      branch_name,
      account_name,
      account_no,
    ]);
    if (index === true) {
      props.showLoading();
      const res = await addMethodBank({
        platform: Platform.OS,
        bank_id: bank_id.id,
        branch_name,
        account_name: account_name.toUpperCase(),
        account_no,
      });
      props.hideLoading();
      if (res.data.code == 200) {
        setTimeout(() => {
          Alert.alert(I18n.t('Notification'), res.data.message);
          navigate.goBack();
        }, 500);
      } else {
        setTimeout(() => {
          Alert.alert(I18n.t('Notification'), res.data.message);
        }, 500);
      }
    } else {
      Alert.alert(
        I18n.t('Notification'),
        I18n.t('Please_fill_in') + titles[index],
      );
    }
  };

  return (
    <KeyboardAvoidingView
      behavior={Platform.Os === 'ios' ? 'padding' : 'height'}
      style={{flex: 1}}
      keyboardVerticalOffset={-50}>
      <TouchableWithoutFeedback onPress={Keyboard.dismiss}>
        <View style={{flex: 1}}>
          <HeaderBack title={'AddPaymentMethod'} />
          <View style={styles.container}>
            <View style={{flex: 1}}>
              <Text style={styles.txtTitle}>{I18n.t('SelectBank')}</Text>
              {/*<PickerItem*/}
              {/*  value={bank_id}*/}
              {/*  data={data}*/}
              {/*  onValueChange={(value, items) => {*/}
              {/*    setBankID(items);*/}
              {/*  }}*/}
              {/*/>*/}
              <SelectBankModal
                  title={I18n.t('SelectBank')}
                  data={data}
                  onPressItem = {(item) => {
                    setBankID(item)
                  }}
              />
              <TextField
                onChangeText={(val) => setBankName(val)}
                title={I18n.t('Branch')}
              />

              <TextField
                onChangeText={(val) => setAccountName(val)}
                title={I18n.t('OwnerAccountName')}
              />
              <TextField
                onChangeText={(val) => setAccountNo(val)}
                title={I18n.t('AccountNumber')}
                isNumber={true}
              />
            </View>
            <View style={{justifyContent: 'center', alignItems: 'center'}}>
              <TouchableOpacity onPress={onLick} style={styles.btn}>
                <Text style={styles.txtAdd}>{I18n.t('Add')}</Text>
              </TouchableOpacity>
            </View>
          </View>
        </View>
      </TouchableWithoutFeedback>
    </KeyboardAvoidingView>
  );
};

const styles = StyleSheet.create({
  container: {
    paddingHorizontal: 10,
    paddingTop: 10,
    flex: 1,
  },

  btn: {
    width: 150,
    height: 40,
    justifyContent: 'center',
    alignItems: 'center',
    backgroundColor: R.colors.main,
    borderRadius: 5,
    marginBottom: 10,
  },
  txtAdd: {
    color: R.colors.white,
    fontSize: getFontXD(46),
    textTransform: 'uppercase',
    fontWeight: 'bold',
  },
  txtTitle: {
    fontSize: getFontXD(42),
    color: R.colors.color777,
    marginBottom: 5,
  },
});

const mapStateToProps = (state) => {
  return {
    user: state.userReducer,
  };
};
export default connect(mapStateToProps, {
  showLoading,
  hideLoading,
})(AddMethodPay);
