import React from 'react';
import {Text, View, TextInput, Button, Alert, StyleSheet} from 'react-native';
import {useForm, Controller} from 'react-hook-form';

export default function App() {
  const {control, handleSubmit, errors} = useForm();
  const onSubmit = (data) => console.log(data);

  console.log(errors);
  return (
    <View>
      <Controller
        control={control}
        render={({onChange, onBlur, value}) => (
          <TextInput
            style={styles.input}
            onBlur={onBlur}
            placeholderTextColor={R.colors.placeHolder}
            onChangeText={(value) => onChange(value)}
            value={value}
          />
        )}
        name="firstName"
        rules={{required: true}}
        defaultValue=""
      />
      {/* {errors.firstName && <Text>This is required.</Text>} */}

      <Controller
        control={control}
        render={({onChange, onBlur, value}) => (
          <TextInput
            style={styles.input}
            placeholderTextColor={R.colors.placeHolder}
            onBlur={onBlur}
            onChangeText={(value) => onChange(value)}
            value={value}
          />
        )}
        name="lastName"
        defaultValue=""
        rules={{required: true, minLength: 6, maxLength: 10}}
      />

      <Button title="Submit" onPress={handleSubmit(onSubmit)} />
    </View>
  );
}

const styles = StyleSheet.create({
  input: {
    height: 50,
    backgroundColor: '#fafafa',
    fontSize: 22,
    marginTop: 50,
    marginHorizontal: 20,
    borderWidth: 0.6,
    borderRadius: 20,
    paddingHorizontal: 10,
  },
});
