import React from 'react';
import {View, Text, StyleSheet, Image} from 'react-native';
import Icon from 'react-native-vector-icons/AntDesign';
import R from '../../assets/R';
import {WIDTHXD, HEIGHTXD, getFontXD, toPriceVnd} from '../../Config/Functions';
import AppText from '../../components/AppText';
const Footer = (props) => {
  return (
    <View style={{marginHorizontal: 20, marginTop: 10}}>
      <View style={styles.container}>
        <View style={styles.wraperImg}>
          <Image source={R.images.moneyteam} style={styles.imgIcon} />
        </View>
        <View style={{flex: 1, paddingHorizontal: 15}}>
          <AppText i18nKey={'RevenueTeam'} style={styles.txt}></AppText>
          <Text style={styles.txtMoney}>0 Đ</Text>
        </View>
        <View style={{justifyContent: 'center', alignItems: 'center'}}>
          <Icon name={'right'} size={20} color={'#707070'} />
        </View>
      </View>

      <View style={styles.container}>
        <View style={styles.wraperImg}>
          <Image source={R.images.moneysupport} style={styles.imgIcon} />
        </View>
        <View style={{flex: 1, paddingHorizontal: 15}}>
          <AppText i18nKey={'RevenueDonors'} style={styles.txt}></AppText>
          <Text style={styles.txtMoney}> 0 Đ</Text>
        </View>
        <View style={{justifyContent: 'center', alignItems: 'center'}}>
          <Icon name={'right'} size={20} color={'#707070'} />
        </View>
      </View>

      <View style={styles.container}>
        <View style={styles.wraperImg}>
          <Image source={R.images.moneyinvest} style={styles.imgIcon} />
        </View>
        <View style={{flex: 1, paddingHorizontal: 15}}>
          <AppText i18nKey={'Invset'} style={styles.txt}></AppText>
          <Text style={styles.txtMoney}>0 Đ</Text>
        </View>
        <View style={{justifyContent: 'center', alignItems: 'center'}}>
          <Icon name={'right'} size={20} color={'#707070'} />
        </View>
      </View>
      <View style={{height: 20}} />
    </View>
  );
};

export default Footer;

const styles = StyleSheet.create({
  imgIcon: {
    width: WIDTHXD(150),
    height: HEIGHTXD(150),
    resizeMode: 'contain',
  },
  wraperImg: {
    justifyContent: 'center',
    alignItems: 'center',
    backgroundColor: '#DFE7F5',
    width: HEIGHTXD(200),
    height: HEIGHTXD(200),
    borderRadius: 10,
  },
  container: {
    backgroundColor: R.colors.white,
    padding: 10,
    borderRadius: 10,
    flexDirection: 'row',
    shadowColor: '#000',
    shadowOffset: {
      width: 0,
      height: 1,
    },
    shadowOpacity: 0.25,
    shadowRadius: 2.84,
    elevation: 3,
    justifyContent: 'space-between',
    marginBottom: 10,
  },
  txt: {
    color: '#8F909E',
    fontSize: getFontXD(36),
  },
  txtMoney: {
    fontSize: getFontXD(42),
    color: R.colors.black,
    marginTop: 5,
  },
});
