import React from 'react';
import {View, Text, StyleSheet, TouchableOpacity} from 'react-native';
import {getFontXD, HEIGHTXD, WIDTHXD, toPriceVnd} from '../../Config/Functions';
import R from '../../assets/R';
import Block from '../../components/Block';
import I18n from '../../helper/i18/i18n';
import {useNavigation} from '@react-navigation/native';
import {DETAIL_REQUIRE_MONEY} from '../../routers/ScreenNames';

const Item = (props) => {
  const {item} = props;
  const navigate = useNavigation();
  return (
    <TouchableOpacity onPress={() => console.log('hello')}>
      <View style={styles.container}>
        <Block flex={1} row>
          <View style={[styles.wrapLeft, {backgroundColor: item.color}]} />
          <View style={styles.wrapDate}>
            <Text style={styles.txt}>T{item.month}</Text>
            <Text style={styles.txtTitle}>{item.day}</Text>
          </View>
          <Block
            style={styles.wrapRight}
            padding={[5, 10]}
            space={'between'}
            flex={1}>
            <View style={styles.rowBet}>
              <Text style={styles.txt}>{item.name}</Text>
              <Text
                style={{
                  fontSize: getFontXD(42),
                  fontWeight: 'bold',
                  color: '#FFB721',
                }}>
                {toPriceVnd(item.money)}
              </Text>
            </View>
            <Text numberOfLines={1} style={styles.txtTitle}>
              {item.note}
            </Text>
            <Text style={styles.txtDate}>`${I18n.t('Date')} ${item.date}`</Text>
          </Block>
        </Block>
      </View>
    </TouchableOpacity>
  );
};

export default Item;

const styles = StyleSheet.create({
  container: {
    height: HEIGHTXD(280),
    shadowColor: '#000',
    shadowOffset: {
      width: 0,
      height: 2,
    },
    shadowOpacity: 0.25,
    shadowRadius: 3.84,
    elevation: 5,
    marginHorizontal: 10,
    backgroundColor: R.colors.white,
    marginTop: 10,
    borderRadius: HEIGHTXD(30),
    marginBottom: 10,
  },
  wrapRight: {
    borderLeftColor: R.colors.borderGray,
    borderLeftWidth: 0.7,
  },
  wrapLeft: {
    width: WIDTHXD(16),
    borderTopLeftRadius: HEIGHTXD(30),
    borderBottomStartRadius: HEIGHTXD(30),
  },
  wrapDate: {
    justifyContent: 'center',
    paddingHorizontal: 10,
  },
  txtTitle: {
    fontSize: getFontXD(48),
    color: R.colors.black,
    fontWeight: '700',
  },
  txt: {
    fontSize: getFontXD(36),
    color: '#363636',
  },
  txtDate: {
    fontSize: getFontXD(39),
    color: '#363636',
    fontStyle: 'italic',
  },
  rowBet: {
    flexDirection: 'row',
    justifyContent: 'space-between',
    alignItems: 'center',
  },
});
