import React, {useState, useEffect} from 'react';
import {Alert} from 'react-native';
import HistoryView from './HistoryView';
import {getListTransaction} from '../../../apis/Functions/Widthdraw';
import I18n from '../../../helper/i18/i18n';

const History = (props) => {
  const [selected, setSelected] = useState('ALL');
  const [page, setPage] = useState(1);
  const [data, setData] = useState([]);
  const [tottalPage, setTotalPage] = useState(1);
  const [isRefresh, setisRefresh] = useState(false);

  useEffect(() => {
    getData();
  }, []);

  useEffect(() => {
    getData();
  }, [selected]);

  const getData = async () => {
    setisRefresh(true);
    setPage(1);
    const res = await getListTransaction({
      keyword: '',
      type: selected,
      platform: Platform.OS,
      page_size: 10,
      status: -1,
      page_index: 1,
      start_date: '',
      end_date: '',
    });

    setisRefresh(false);
    if ((res.data.code = 200 && res.data.data)) {
      setData(res.data.data);
      setTotalPage(res.data.meta.pages);
      console.log(res.data.data);
    } else {
      Alert.alert(I18n.t('Notification'), res.data.message);
    }
  };

  const onRefresh = () => {
    getData();
  };

  const onLoadMore = () => {
    if (page < tottalPage) getDataLoadMore();
  };

  const getDataLoadMore = async () => {
    setisRefresh(true);
    const res = await getListTransaction({
      keyword: '',
      type: 'ALL',
      platform: Platform.OS,
      page_size: 10,
      status: -1,
      page_index: page + 1,
      start_date: '',
      end_date: '',
    });
    setPage(page + 1);

    if (res.data.code == 200) {
      setData(data.concat(res.data.data));
    }
    setisRefresh(false);
  };

  return (
    <HistoryView
      onLoadMore={onLoadMore}
      isRefresh={isRefresh}
      onRefresh={onRefresh}
      data={data}
      selected={selected}
      setSelected={setSelected}
    />
  );
};

export default History;
