import React, {useState} from 'react';
import {
  View,
  Text,
  Image,
  StatusBar,
  StyleSheet,
  SafeAreaView,
  ImageBackground,
  TouchableOpacity,
  Platform,
  Button,
  TouchableWithoutFeedback,
  TextInput,
} from 'react-native';
import R from '../../assets/R';
import {getFontXD, HEIGHT, WIDTHXD} from '../../Config/Functions';
import LinearGradient from 'react-native-linear-gradient';
import {connect} from 'react-redux';
import {HEIGHTXD} from '../../Config/Functions';

import Icon from 'react-native-vector-icons/Ionicons';
import {useNavigation} from '@react-navigation/native';

const HeaderSearch = (props) => {
  const {title, isWhite} = props;

  const [openSearch, setOpenSearch] = useState(false);
  const [txtSearch, setTxtSearch] = useState('');
  const toggleSearch = () => {
    setTxtSearch('');
    setOpenSearch(!openSearch);
  };
  const navigate = useNavigation();

  return (
    <ImageBackground
      style={[styles.img, isWhite ? {backgroundColor: 'white'} : {}]}
      source={R.images.bgHeader}>
      <StatusBar backgroundColor="transparent" translucent={true} />
      <View style={styles.headerContainer}>
        <TouchableOpacity onPress={() => navigate.goBack()}>
          <Image source={R.images.iconBack} style={styles.imgIcon} />
        </TouchableOpacity>

        {openSearch ? (
          <TextInput
            placeholderTextColor={R.colors.placeHolder}
            style={styles.txtInput}
            onChangeText={(val) => setTxtSearch(val)}
            value={txtSearch}
          />
        ) : (
          <Text style={styles.txtTitle}>{title ? title : ''} </Text>
        )}
        <TouchableOpacity onPress={toggleSearch}>
          {openSearch ? (
            <Icon name={'refresh-outline'} size={28} color={R.colors.white} />
          ) : (
            <Icon name={'search-sharp'} size={28} color={R.colors.white} />
          )}
        </TouchableOpacity>
      </View>
    </ImageBackground>
  );
};

const mapStateToProps = (state) => {
  return {
    user: state.userReducer,
  };
};

export default connect(mapStateToProps, {})(HeaderSearch);

const styles = StyleSheet.create({
  img: {
    height: 110,
    width: '100%',

    justifyContent: 'center',
    alignItems: 'center',
  },
  headerContainer: {
    height: 55,
    width: '100%',
    alignItems: 'center',
    flexDirection: 'row',
    paddingHorizontal: 20,
    justifyContent: 'space-between',
  },
  imgIcon: {
    width: 25,
    height: 20,
  },
  txtTitle: {
    fontSize: getFontXD(52),
    color: R.colors.white,
    fontWeight: 'bold',
  },
  container: {
    backgroundColor: 'white',
    height: '100%',
    width: 300,
    borderRadius: 20,
  },
  txtInput: {
    backgroundColor: R.colors.white,
    flex: 1,
    padding: 2,
    height: HEIGHTXD(100),
    fontSize: getFontXD(42),
    borderRadius: 10,
    marginHorizontal: 10,
    paddingHorizontal: 10,
    color: 'black',
  },
  btnIcon: {
    backgroundColor: R.colors.lightBlue2,
    padding: 5,
  },
});
