import React, {useEffect, useState} from 'react';
import {
  View,
  Text,
  Image,
  StatusBar,
  StyleSheet,
  SafeAreaView,
  ImageBackground,
  TouchableOpacity,
  Platform,
  Alert,
} from 'react-native';
import R from '../../assets/R';
import {getFontXD, HEIGHT, WIDTHXD} from '../../Config/Functions';
import LinearGradient from 'react-native-linear-gradient';
import {connect} from 'react-redux';
import {HEIGHTXD, toPriceVnd} from '../../Config/Functions';
import Clipboard from '@react-native-clipboard/clipboard';

import {useNavigation} from '@react-navigation/native';
import {
  WITHDRAW,
  DEPOSIT,
  CHOOSEMETHOD,
  TRANSFER,
  HISTORY,
  PROFILE,
} from '../../routers/ScreenNames';

const HeaderHome = (props) => {
  const navigate = useNavigation();

  console.log();

  const copyToClipboard = () => {
    Alert.alert('Đã sao chép!');
    Clipboard.setString(props.user.sponsor_url);
  };

  return (
    <View style={styles.container}>
      <ImageBackground style={styles.img} source={R.images.headerHome}>
        <StatusBar backgroundColor="transparent" translucent={true} />
      </ImageBackground>
      <View style={{justifyContent: 'center', alignItems: 'center'}}>
        <View style={styles.containerTop}>
          <View style={styles.containerInfor}>
            <Image source={R.images.avartar} style={styles.imgAvatar} />
            <View style={styles.wrapRight}>
              <TouchableOpacity onPress={() => navigate.navigate(PROFILE)}>
                <Text style={styles.txtName}>{props.user.fullname}</Text>
              </TouchableOpacity>

              <View style={styles.row1}>
                <Text style={styles.txtlink}>ID:{props.user.user_id}</Text>
                <TouchableOpacity onPress={copyToClipboard}>
                  <Image
                    source={R.images.iconCopy}
                    style={styles.imgIconCopy}
                  />
                </TouchableOpacity>
              </View>
            </View>
          </View>
          {/* <View style={styles.row}>
            <Text style={styles.txtMoney}>
              {' '}
              {props.user.current_money == 0
                ? 0
                : toPriceVnd(props.user.current_money)}
            </Text>
            <Text style={styles.txtTitle}> Đ</Text>
          </View> */}

          <View style={styles.containerMenu}>
            <TouchableOpacity
              onPress={() => navigate.navigate(CHOOSEMETHOD)}
              style={styles.wraper}>
              <Image style={styles.imgIcon} source={R.images.iconRecharge} />
              <Text style={styles.txt}>Nạp tiền</Text>
            </TouchableOpacity>

            <TouchableOpacity
              onPress={() => navigate.navigate(WITHDRAW)}
              style={styles.wraper}>
              <Image style={styles.imgIcon} source={R.images.iconWithdrawal} />
              <Text style={styles.txt}>Rút tiền</Text>
            </TouchableOpacity>
            <TouchableOpacity
              onPress={() => navigate.navigate(TRANSFER)}
              style={styles.wraper}>
              <Image style={styles.imgIcon} source={R.images.iconTransfer} />
              <Text style={styles.txt}>Chuyển khoản</Text>
            </TouchableOpacity>
            <TouchableOpacity
              onPress={() => navigate.navigate(HISTORY)}
              style={styles.wraper}>
              <Image style={styles.imgIcon} source={R.images.iconHistory} />
              <Text style={styles.txt}>Lịch sử</Text>
            </TouchableOpacity>
          </View>
        </View>
      </View>
    </View>
  );
};

const mapStateToProps = (state) => {
  return {
    user: state.userReducer,
  };
};

export default connect(mapStateToProps, {})(HeaderHome);

const styles = StyleSheet.create({
  container: {},

  img: {
    height: Platform.OS == 'ios' ? HEIGHTXD(728) : HEIGHTXD(808),
    width: '100%',

    justifyContent: 'center',
    alignItems: 'center',
  },
  containerTop: {
    height: HEIGHTXD(856),
    width: '90%',
    backgroundColor: 'white',
    borderRadius: 10,
    shadowColor: '#000',
    shadowOffset: {
      width: 0,
      height: 1,
    },
    shadowOpacity: 0.25,
    shadowRadius: 2.84,
    elevation: 3,
    marginTop: -180,
  },
  containerMenu: {
    justifyContent: 'space-between',
    alignItems: 'center',
    flexDirection: 'row',
    padding: 10,
  },
  wraper: {
    justifyContent: 'center',
    alignItems: 'center',
  },
  imgIcon: {
    width: WIDTHXD(134),
    height: HEIGHTXD(134),
    marginBottom: 10,
    resizeMode: 'contain',
  },
  imgIconCopy: {
    width: WIDTHXD(134),
    height: HEIGHTXD(134),

    resizeMode: 'contain',
  },
  txt: {
    fontSize: getFontXD(36),
    color: R.colors.txtMain,
  },
  txtName: {
    fontSize: getFontXD(52),
    color: '#00359C',
  },
  txtlink: {
    fontSize: getFontXD(42),
    color: '#A2A2A2',
  },
  imgAvatar: {
    width: WIDTHXD(240),
    height: WIDTHXD(240),
    borderRadius: WIDTHXD(120),
  },
  txtMoney: {
    fontSize: getFontXD(62),
    color: '#FFB721',
    marginVertical: 5,
    fontWeight: 'bold',
  },
  txtTitle: {
    fontSize: getFontXD(42),
    color: '#A2A2A2',
    fontWeight: 'bold',
    marginTop: 5,
    marginLeft: 5,
  },
  wrapRight: {
    flex: 1,
    paddingHorizontal: 20,
  },
  containerInfor: {
    flex: 1,
    justifyContent: 'center',
    alignItems: 'center',
    borderBottomWidth: 1,
    borderBottomColor: '#EDEDF1',
    flexDirection: 'row',
    paddingHorizontal: 20,
  },
  row: {
    flexDirection: 'row',
    alignItems: 'center',
    marginTop: 5,
  },
  row1: {
    flexDirection: 'row',
    justifyContent: 'space-between',
    alignItems: 'center',
  },
});
