import React from 'react';
import {View, Text, StyleSheet, Image, TouchableOpacity} from 'react-native';
import R from '../../assets/R';
import {HEIGHTXD, getFontXD, WIDTHXD} from '../../Config/Functions';
import Icon from 'react-native-vector-icons/MaterialIcons';
import AsyncStorage from '@react-native-community/async-storage';
import {
  AccountVerification,
  METHODPAY,
  SERVICECUSTOMER,
  FEEDBACK,
  SETTING,
  NOTIFICATION,
  AUTHEN,
  PROFILE,
  CONTRACT,
} from '../../routers/ScreenNames';
import {useNavigation} from '@react-navigation/native';
import {connect} from 'react-redux';

const menus = [
  {
    id: '1',
    title: 'Xác minh tài khoản',
    icon: R.images.iconUserCheck,
    screen: AccountVerification,
  },
  {
    id: '6',
    title: 'Hợp đồng',
    icon: R.images.iconContract,
    screen: CONTRACT,
  },

  {
    id: '2',
    title: 'Cài đặt phương thức thanh toán',
    icon: R.images.iconMethodPay,
    screen: METHODPAY,
  },
  {
    id: '3',
    title: 'Liên hệ với dịch vụ khách hàng',
    icon: R.images.iconPhone,
    screen: SERVICECUSTOMER,
  },
  {
    id: '4',
    title: 'Phản hồi',
    icon: R.images.iconMess,
    screen: FEEDBACK,
  },
  {
    id: '5',
    title: 'Cài đặt',
    icon: R.images.iconSetting,
    screen: SETTING,
  },
];

const Drawer = (props) => {
  const navigate = useNavigation();
  return (
    <View style={styles.container}>
      <View style={styles.header}>
        <Image source={R.images.avartar} style={styles.imgAvatar} />
        <TouchableOpacity
          onPress={() => {
            props.toggleModal();
            navigate.navigate(PROFILE);
          }}>
          <Text style={styles.txtTop}>{props.user.fullname}</Text>
          <Text>{props.user.sponsor_id}</Text>
        </TouchableOpacity>
        <TouchableOpacity
          onPress={() => {
            props.toggleModal();
            navigate.navigate(PROFILE);
          }}>
          <Image source={R.images.iconRight2} style={styles.imgIcon} />
        </TouchableOpacity>
      </View>

      <View style={styles.body}>
        {menus.map((e) => (
          <TouchableOpacity
            onPress={() => {
              navigate.navigate(e.screen);
              props.toggleModal();
            }}
            key={e.id}
            style={styles.containerItem}>
            <Image source={e.icon} style={styles.imgIcon} />
            <Text style={styles.txtTitle}>{e.title}</Text>
          </TouchableOpacity>
        ))}
      </View>

      <TouchableOpacity
        onPress={() => {
          AsyncStorage.clear();
          props.toggleModal();
          navigate.reset({
            index: 1,
            routes: [{name: AUTHEN}],
          });
        }}
        style={styles.footer}>
        <Icon name={'logout'} size={25} color={'#F81515'} />
        <Text style={styles.txtTitle}>Đăng xuất</Text>
      </TouchableOpacity>
    </View>
  );
};

const styles = StyleSheet.create({
  container: {
    flex: 1,
    padding: 20,
  },
  header: {
    paddingVertical: 10,
    borderWidth: 1,
    borderRadius: WIDTHXD(64),
    borderColor: '#C9D3FF',
    flexDirection: 'row',
    alignItems: 'center',
    paddingHorizontal: 10,
    justifyContent: 'space-around',
  },
  body: {
    flex: 1,

    marginVertical: 30,
  },
  imgAvatar: {
    width: WIDTHXD(140),
    height: WIDTHXD(140),
    borderRadius: WIDTHXD(100),
  },
  imgIcon: {
    width: WIDTHXD(62),
    height: HEIGHTXD(52),
    resizeMode: 'contain',
  },
  txtTitle: {
    fontSize: getFontXD(36),
    marginLeft: 10,
    color: '#0C0D2C',
  },
  txtTop: {
    fontSize: getFontXD(42),
    color: '#1E2F70',
  },
  txtLink: {
    fontSize: getFontXD(36),
    color: '#929292',
  },

  footer: {
    paddingVertical: 10,
    backgroundColor: '#EEEEEE',
    borderRadius: WIDTHXD(75),
    flexDirection: 'row',
    alignItems: 'center',
    paddingHorizontal: 20,
  },
  containerItem: {
    flexDirection: 'row',
    alignItems: 'center',
    marginVertical: 10,
    borderRadius: WIDTHXD(75),

    paddingVertical: 10,
    paddingHorizontal: 10,
  },
});

const mapStateToProps = (state) => {
  return {
    user: state.userReducer,
  };
};

export default connect(mapStateToProps, {})(Drawer);
