import React, {useState} from 'react';
import {View, Text, FlatList, StyleSheet, TouchableOpacity} from 'react-native';

import HeaderDrawer from '../../components/Header/HeaderDrawer';
import Item from './Item';
import {getFontXD} from '../../Config/Functions';

const Fillters = [
  {
    id: '1',
    name: 'Tất cả',
    value: 'all',
  },
  {
    id: '2',
    name: 'Chưa đọc',
    value: 'disable',
  },
  {
    id: '3',
    name: 'Đã đọc',
    value: 'enable',
  },
  {
    id: '4',
    name: 'Rút tiền',
    value: 'withdraw',
  },
  {
    id: '5',
    name: 'Nạp tiền',
    value: 'deposit',
  },
  {
    id: '6',
    name: 'Chuyển khoản',
    value: 'exchange',
  },
];

const data = [
  {
    id: '1',
    time: '20/02/2021',
    content: 'Yêu cầu nạp tiền của bạn đã đươc xác nhận',
  },
  {
    id: '2',
    time: '20/02/2021',
    content: 'Yêu cầu nạp tiền của bạn đã đươc xác nhận',
  },
  {
    id: '3',
    time: '20/02/2021',
    content: 'Yêu cầu nạp tiền của bạn đã đươc xác nhận',
  },
  {
    id: '4',
    time: '20/02/2021',
    content: 'Yêu cầu nạp tiền của bạn đã đươc xác nhận',
  },
];

const NotificaitonView = (props) => {
  const [selected, setSelected] = useState('1');

  return (
    <View style={{flex: 1}}>
      <HeaderDrawer isWhite={false} title={'Thông báo'} />
      <View style={styles.headerContainer}>
        <FlatList
          showsHorizontalScrollIndicator={false}
          horizontal
          data={Fillters}
          keyExtractor={(item) => item.id}
          renderItem={({item}) => (
            <TouchableOpacity
              onPress={() => setSelected(item.id)}
              style={[
                styles.itemFillter,
                selected == item.id ? {borderColor: '#1473E6'} : null,
              ]}>
              <Text
                style={[
                  styles.txtFillter,
                  selected == item.id ? {color: '#1473E6'} : {},
                ]}>
                {item.name}
              </Text>
            </TouchableOpacity>
          )}
        />
      </View>
      <FlatList
        keyExtractor={(item) => item.id}
        data={data}
        renderItem={({item}) => <Item item={item} />}
      />
    </View>
  );
};

const styles = StyleSheet.create({
  headerContainer: {
    paddingVertical: 10,
    backgroundColor: 'white',
  },
  itemFillter: {
    borderRadius: 10,
    paddingVertical: 5,
    paddingHorizontal: 10,
    borderWidth: 1,
    borderColor: '#929292',
    marginLeft: 15,
    minWidth: 70,
  },
  txtFillter: {
    fontSize: getFontXD(36),
    color: '#929292',
  },
});

export default NotificaitonView;
