import React, {Component} from 'react';
import {View, Text, StyleSheet, TouchableOpacity} from 'react-native';
import R from '../../../assets/R';
import Block from '../../../components/Block';
import {getFontXD} from '../../../Config/Functions';
const Item = (props) => {
  const {title, date, time} = props.item;
  return (
    <TouchableOpacity
      onPress={() => console.log('hello')}
      style={styles.container}>
      <View style={styles.left}>
        <View style={styles.dot} />
      </View>
      <View style={[styles.right, props.index == 0 ? {borderTopWidth: 0} : {}]}>
        <View style={styles.row}>
          <Text style={styles.txtTime}>{time}</Text>
          <Text style={styles.txtDate}>{date}</Text>
        </View>
        <Text style={styles.txtTitle}>
          {title}+{props.index}
        </Text>
      </View>
    </TouchableOpacity>
  );
};

export default Item;

const styles = StyleSheet.create({
  container: {
    flexDirection: 'row',
    marginLeft: 10,
  },
  left: {
    width: 0.6,
    backgroundColor: '#CECECE',
  },
  right: {
    marginLeft: 20,
    paddingVertical: 20,
    borderTopWidth: 0.6,
    borderBottomWidth: 0.6,
    borderColor: '#CECECE',
    flex: 1,
  },
  row: {
    flexDirection: 'row',
    justifyContent: 'space-between',
    marginBottom: 5,
  },
  dot: {
    width: 10,
    height: 10,
    backgroundColor: R.colors.main,
    borderRadius: 5,
    marginLeft: -5,
    marginTop: 25,
  },
  txtTitle: {
    fontSize: getFontXD(42),
  },
  txtTime: {
    fontSize: getFontXD(42),
    color: R.colors.main,
  },
  txtDate: {
    color: '#929292',
  },
});
