import React, {Component} from 'react';

import {View, Text, StyleSheet, Image, TouchableOpacity} from 'react-native';
import Block from '../../../components/Block';
import Icon from 'react-native-vector-icons/AntDesign';
import {getFontXD} from '../../../Config/Functions';
import R from '../../../assets/R';
import {useNavigation} from '@react-navigation/native';
import {DETAILNEW} from '../../../routers/ScreenNames';

const Item = (props) => {
  const navigate = useNavigation();
  const {title, image, published_at, id} = props.item;
  return (
    <TouchableOpacity
      onPress={() => navigate.navigate(DETAILNEW, {id})}
      style={styles.container}>
      <Text numberOfLines={2} style={styles.txtTitle}>
        {title}
      </Text>
      <Text style={styles.txtDate}>{published_at}</Text>
      <Image source={{uri: image}} resizeMode={'cover'} style={styles.img} />
    </TouchableOpacity>
  );
};

const styles = StyleSheet.create({
  container: {
    marginVertical: 15,
  },
  row: {
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'space-between',
    marginVertical: 10,
  },

  txtTitle: {
    fontSize: getFontXD(46),
    color: 'black',
    fontWeight: 'bold',
  },
  txtDate: {
    fontSize: getFontXD(46),
    fontStyle: 'italic',
    color: '#A2A2A2',
  },
  img: {
    width: '100%',
    height: 260,
    borderRadius: 5,
    marginTop: 5,
  },
});

export default Item;
