import React, {useState, useEffect} from 'react';
import {
  View,
  Text,
  StyleSheet,
  ScrollView,
  TouchableOpacity,
  FlatList,
  Platform,
  Alert,
} from 'react-native';
import R from '../../../assets/R';
import {getFontXD} from '../../../Config/Functions';
import Item from './item';
import {getListNew} from '../../../apis/Functions/NewFeed';

const fillers = [
  {
    id: '1',
    title: 'Ngoại hối',
  },
  {
    id: '2',
    title: 'Cổ phiếu',
  },
  {
    id: '3',
    title: 'Hàng hoá',
  },
  {
    id: '4',
    title: 'Chỉ số',
  },
];

const NewFeed = (props) => {
  const [selected, setSelected] = useState(1);
  const [page, setPage] = useState(1);
  const [data, setData] = useState([]);
  const [tottalPage, setTotalPage] = useState(1);
  const [isRefresh, setisRefresh] = useState(false);

  useEffect(() => {
    getData();
  }, []);

  const getData = async () => {
    const res = await getListNew({
      keyword: '',
      category_id: '',
      platform: Platform.OS,
      page_size: 10,
      page_index: page,
    });
    if ((res.data.code = 200 && res.data.data)) {
      setData(res.data.data);
    } else {
      Alert.alert('Thông báo!', res.data.message);
    }
  };

  const onRefresh = () => {
    console.log('On Refersh');
  };

  const onLoadMore = () => {
    console.log('Load more');
  };

  // const getDataLoadMore=async ()=>{
  //   setisRefresh(true)
  //   const res=await GetListNotification({keyword:txtSearch,page_index:page+1,page_size:8,platform:Platform.OS})
  //   setPage(page+1)

  //   if(res.data.code==200){
  //       setData(data.concat(res.data.data))
  //   }
  //   setisRefresh(false)
  // }

  // const onLoadMore=()=>{
  //   if(page<tottalPage)
  //     getDataLoadMore()

  // }

  return (
    <View style={{flex: 1, backgroundColor: 'white'}}>
      <View style={styles.fillterView}>
        <ScrollView horizontal showsHorizontalScrollIndicator={false}>
          {fillers.map((e) => (
            <TouchableOpacity
              onPress={() => setSelected(e.id)}
              key={e.id}
              style={[
                styles.item,
                e.id == selected ? {backgroundColor: '#BCD7F8'} : {},
              ]}>
              <Text
                style={[
                  styles.txt,
                  e.id == selected ? {color: '#1C6AF6'} : {},
                ]}>
                {e.title}
              </Text>
            </TouchableOpacity>
          ))}
        </ScrollView>
      </View>
      <View style={{flex: 1, paddingHorizontal: 10}}>
        <FlatList
          showsVerticalScrollIndicator={false}
          keyExtractor={(item, index) => item.id}
          refreshing={isRefresh}
          onRefresh={() => onRefresh()}
          onEndReachedThreshold={0.01}
          onEndReached={(info) => {
            onLoadMore();
          }}
          data={data}
          renderItem={({item}) => <Item item={item} />}
        />
      </View>
    </View>
  );
};

export default NewFeed;

const styles = StyleSheet.create({
  fillterView: {
    flexDirection: 'row',
    alignItems: 'center',
    paddingVertical: 10,
  },
  item: {
    backgroundColor: '#EBEBEB',
    marginRight: 40,
    paddingHorizontal: 10,
    paddingVertical: 6,
    marginLeft: 20,
  },
  txt: {
    fontSize: getFontXD(42),
    color: R.colors.black,
  },
});
