import React from 'react';
import {View, Text, StyleSheet, FlatList, TouchableOpacity} from 'react-native';
import R from '../../assets/R';
import HeaderBack from '../../components/Header/HeaderBack';
import Item from './Item';
import {WIDTHXD} from '../../Config/Functions';
import Icon from 'react-native-vector-icons/Entypo';
import {useNavigation} from '@react-navigation/native';
import {ADDMETHODPAY} from '../../routers/ScreenNames';
const data = [
  {
    image: R.images.iconNganLuong,
    title: 'Ngân lượng',
    rose: 0,
    time: 'Tức thời',
    minPay: 5,
    id: '1',
  },
  {
    image: R.images.iconVisa,
    title: 'Visa bank',
    rose: 0,
    time: 'Tức thời',
    minPay: 1,
    id: '2',
  },
  {
    image: R.images.iconInternet,
    title: 'Internet banking',
    rose: 0,
    time: 'Tức thời',
    minPay: 5,
    id: '3',
  },
  {
    image: R.images.iconBitcoin,
    title: 'Bitcoin',
    rose: 0,
    time: 'Tức thời',
    minPay: 2,
    id: '4',
  },
  {
    image: R.images.iconSticpay,
    title: 'Sticpay',
    rose: 0,
    time: 'Tức thời',
    minPay: 1,
    id: '5',
  },
  {
    image: R.images.iconTether,
    title: 'Tether',
    rose: 0,
    time: 'Tức thời',
    minPay: 10,
    id: '6',
  },
];

const MethodPayView = (props) => {
  const navigate = useNavigation();
  return (
    <View style={{flex: 1}}>
      <HeaderBack title={'Cài đặt phương thức thanh toán'} />
      <View style={{flex: 1}}>
        <FlatList
          keyExtractor={(item) => item.id}
          showsVerticalScrollIndicator={false}
          data={data}
          renderItem={({item}) => <Item item={item} />}
        />

        <TouchableOpacity
          onPress={() => navigate.navigate(ADDMETHODPAY)}
          style={styles.containerBtn}>
          <Icon name={'plus'} size={27} color={R.colors.white} />
        </TouchableOpacity>
      </View>
    </View>
  );
};

const styles = StyleSheet.create({
  containerBtn: {
    backgroundColor: R.colors.main,
    position: 'absolute',
    bottom: 50,
    right: 20,
    width: WIDTHXD(144),
    height: WIDTHXD(144),
    justifyContent: 'center',
    alignItems: 'center',
    shadowColor: '#000',
    shadowOffset: {
      width: 0,
      height: 2,
    },
    shadowOpacity: 0.25,
    shadowRadius: 3.84,
    elevation: 3,
    borderRadius: 30,
  },
});

export default MethodPayView;
