import React from 'react';
import {View, Text, StyleSheet, TouchableOpacity, Image} from 'react-native';
import {getFontXD, HEIGHTXD, WIDTHXD, toPriceVnd} from '../../Config/Functions';
import R from '../../assets/R';
import Block from '../../components/Block';
import Icon from 'react-native-vector-icons/MaterialCommunityIcons';

const Item = (props) => {
  const {item} = props;
  return (
    <TouchableOpacity onPress={() => console.log('HEllo')}>
      <View style={styles.container}>
        <Block flex={1} row center padding={[10, 20]}>
          <Image source={item.image} style={styles.imgIcon} />
          <Block padding={[0, 10]}>
            <Text style={styles.txtBig}>{item.title}</Text>
            <Block space={'between'} margin={[10, 0, 0, 0]} row flex={1}>
              <Block>
                <Text style={styles.txtLeft}>Tien nap toi thieu</Text>
                <Text style={styles.txtLeft}>Hoa hong</Text>
                <Text style={styles.txtLeft}>Thoi gian</Text>
              </Block>
              <Block>
                <Text style={styles.txtRight}>{item.minPay} USD</Text>
                <Text style={styles.txtRight}>{item.rose} USD</Text>
                <Text style={styles.txtRight}>{item.time}</Text>
              </Block>
            </Block>
          </Block>
        </Block>
      </View>
    </TouchableOpacity>
  );
};

export default React.memo(Item);

const styles = StyleSheet.create({
  container: {
    marginTop: 10,
    height: HEIGHTXD(320),
    shadowColor: '#000',
    shadowOffset: {
      width: 0,
      height: 2,
    },
    shadowOpacity: 0.25,
    shadowRadius: 3.84,
    elevation: 5,
    marginHorizontal: 10,
    backgroundColor: R.colors.white,
    marginBottom: 10,
    borderRadius: HEIGHTXD(30),
  },

  wrapLeft: {
    width: WIDTHXD(16),
    borderTopLeftRadius: HEIGHTXD(30),
    borderBottomStartRadius: HEIGHTXD(30),
  },
  wrapDate: {
    justifyContent: 'center',
    paddingHorizontal: 10,
  },
  txtTitle: {
    fontSize: getFontXD(42),
    color: R.colors.black,
    fontWeight: 'bold',
  },
  txt: {
    fontSize: getFontXD(39),
    color: '#929292',
    fontStyle: 'italic',
  },
  rowBet: {
    flexDirection: 'row',
    justifyContent: 'space-between',
    alignItems: 'center',
  },
  txtBlack: {
    fontSize: getFontXD(42),
    color: 'black',
  },
  imgIcon: {
    width: WIDTHXD(220),
    height: HEIGHTXD(220),
    resizeMode: 'contain',
  },
  txtLeft: {
    fontSize: getFontXD(36),
    color: '#929292',
    marginBottom: 5,
  },
  txtBig: {
    fontSize: getFontXD(42),
    color: '#00359C',
  },
  txtRight: {
    fontSize: getFontXD(36),
    fontWeight: 'bold',
    marginBottom: 5,
  },
});
