import React, {useState} from 'react';
import {
  View,
  Text,
  StyleSheet,
  FlatList,
  Dimensions,
  TouchableOpacity,
} from 'react-native';
import R from '../../assets/R';
import HeaderBack from '../../components/Header/HeaderBack';
import Item from './Item';
import {getFontXD, WIDTHXD} from '../../Config/Functions';
import TextField from '../../components/Input/TextField';
import PickerItem from '../../components/Picker/PickerItem';

const {width} = Dimensions.get('window');
const dataTest = [
  {
    value: '1',
    name: 'Vietnamese',
  },
  {
    value: '2',
    name: 'English',
  },
];

const AddMethodPay = (props) => {
  const [language, setLanguage] = useState(dataTest[0].name);
  return (
    <View style={{flex: 1}}>
      <HeaderBack title={'Thêm phương thức thanh toán'} />
      <View style={styles.container}>
        <Text style={styles.txtTitle}>Chọn ngân hàng </Text>
        <PickerItem
          defaultValue={language}
          value={language}
          data={dataTest}
          onValueChange={(value, items) => {
            setLanguage(items.name);
          }}
        />

        <TextField title={'Chi nhánh'} />
        <TextField title={'Tên chủ tài khoản'} />
        <TextField title={'Số tài khoản ngân hàng'} isNumber={true} />
      </View>
      <TouchableOpacity style={styles.btn}>
        <Text style={styles.txtAdd}>Thêm</Text>
      </TouchableOpacity>
    </View>
  );
};

const styles = StyleSheet.create({
  container: {
    paddingHorizontal: 20,
    paddingTop: 10,
  },

  btn: {
    width: 150,
    height: 40,
    justifyContent: 'center',
    alignItems: 'center',
    backgroundColor: R.colors.main,
    borderRadius: 5,
    position: 'absolute',
    bottom: 30,
    right: width / 2 - 150 / 2,
  },
  txtAdd: {
    color: R.colors.white,
    fontSize: getFontXD(46),
    textTransform: 'uppercase',
    fontWeight: 'bold',
  },
  txtTitle: {
    fontSize: getFontXD(42),
    color: R.colors.color777,
    marginBottom: 5,
  },
});

export default AddMethodPay;
