import React, {useState} from 'react';
import {
  View,
  Text,
  TextInput,
  TouchableOpacity,
  StyleSheet,
  Touchable,
  TouchableOpacityBase,
  Dimensions,
  KeyboardAvoidingView,
  ScrollView,
  Platform,
} from 'react-native';
import R from '../../../../assets/R';

const dataTest = [
  {
    value: '1',
    name: '2020',
  },
  {
    value: '2',
    name: '2021',
  },
];

const {width} = Dimensions.get('window');

import TextField from '../../../../components/Input/TextField';
import PickerItem from '../../../../components/Picker/PickerItem';
import {getFontXD, HEIGHTXD, WIDTHXD} from '../../../../Config/Functions';
import Icon from 'react-native-vector-icons/Ionicons';

const GeneralInfor = (props) => {
  const [Select, setSelect] = useState('ABC');
  const [bank, setBank] = useState();

  return (
    <KeyboardAvoidingView
      behavior={Platform.Os === 'ios' ? 'padding' : 'height'}
      style={{flex: 1}}
      keyboardVerticalOffset={-50}>
      <ScrollView style={{flex: 1}} showsVerticalScrollIndicator={false}>
        <View style={styles.container}>
          <TextField
            title={'Họ và tên'}
            onChangeText={(val) => console.log(val)}
          />
          <TextField
            title={'Điện thoại'}
            onChangeText={(val) => console.log(val)}
          />

          <TextField title={'Email'} onChangeText={(val) => console.log(val)} />
          {/* 
      <TextInput
        style={styles.customTxt}
        onChangeText={(val) => console.log(val)}
        placeholder="0000"
      /> */}

          <View style={styles.status}>
            <View
              style={{
                flexDirection: 'row',
                justifyContent: 'center',
                alignItems: 'center',
              }}>
              <View style={styles.customAdd}>
                <Text style={{fontSize: getFontXD(42), color: '#929292'}}>
                  +
                </Text>
              </View>
              <Text style={styles.txtTitle}>Trạng thái</Text>
            </View>

            <Text style={{color: '#4FCD8D', fontSize: getFontXD(42)}}>
              Đã xác minh
            </Text>
          </View>

          <View
            style={{
              borderTopWidth: 1,
              borderTopColor: '#DBDBDB',
              marginTop: 20,
              paddingTop: 10,
            }}>
            <TextField
              title={'Số tài khoản ngân hàng'}
              onChangeText={(val) => console.log(val)}
              placeHolder="Nhập số tài khoản ngân hàng"
            />

            <Text style={styles.txtTitle}>Tên ngân hàng</Text>
            <PickerItem
              width={width - 20}
              data={dataTest}
              onValueChange={(value, items) => {
                setBank(items);
              }}
            />
          </View>

          <View style={styles.footer}>
            <TouchableOpacity
              onPress={() => console.log('Hello')}
              style={styles.btn}>
              <Text style={styles.txtBtn}>Cập nhật</Text>
            </TouchableOpacity>
          </View>
        </View>
      </ScrollView>
    </KeyboardAvoidingView>
  );
};

const styles = StyleSheet.create({
  container: {
    flex: 1,
    paddingHorizontal: 10,
    paddingVertical: 10,
  },
  customTxt: {
    height: HEIGHTXD(110),
    color: 'black',
    borderRadius: 7,
    borderWidth: 0.7,
    borderColor: '#DBDBDB',
    fontSize: getFontXD(42),
    paddingVertical: 5,
    paddingHorizontal: 10,
    backgroundColor: 'white',
    shadowColor: '#AFA9A9',
    shadowOffset: {
      width: 0,
      height: 1,
    },
    shadowOpacity: 0.25,
    shadowRadius: 1.84,
    elevation: 1,
    marginTop: 50,
    marginBottom: 20,
  },
  status: {
    flexDirection: 'row',
    justifyContent: 'space-between',
    marginTop: 10,
    alignItems: 'center',
  },
  footer: {
    justifyContent: 'center',
    alignItems: 'center',
    marginTop: 30,
  },
  btn: {
    width: WIDTHXD(521),
    height: HEIGHTXD(120),
    borderRadius: 15,
    backgroundColor: '#1C6AF6',
    justifyContent: 'center',
    alignItems: 'center',
  },
  txtBtn: {
    color: R.colors.white,
    fontSize: getFontXD(52),
    textTransform: 'uppercase',
  },
  customAdd: {
    borderWidth: 1,
    borderColor: '#929292',
    paddingHorizontal: 5,
    borderRadius: 5,
    marginRight: 10,
  },
  txtTitle: {
    fontSize: getFontXD(42),
    color: R.colors.color777,
    marginBottom: 5,

    paddingTop: 5,
  },
});

export default GeneralInfor;
