import React from 'react';
import {
  View,
  Text,
  ImageBackground,
  StyleSheet,
  ScrollView,
} from 'react-native';
import HeaderHome from '../../components/Header/HeaderHome';
import Footer from './Footer';
import {HEIGHT, HEIGHTXD, toPriceVnd, getFontXD} from '../../Config/Functions';
import R from '../../assets/R';
const HomeView = (props) => {
  return (
    <View style={{flex: 1}}>
      <HeaderHome />
      <View style={styles.body}>
        <ScrollView
          showsVerticalScrollIndicator={false}
          style={styles.containerBody}>
          <View style={{height: 10}} />
          <View style={styles.containerMenu}>
            <View style={styles.row}>
              <View style={styles.row}>
                <View style={styles.itemMenu}>
                  <Text style={styles.txtTitle}>Nạp tiền</Text>
                  <Text style={styles.txtMoney}> {toPriceVnd(1000000)} Đ </Text>
                </View>
                <View
                  style={{width: 0.5, backgroundColor: R.colors.borderGray}}
                />
                <View style={styles.itemMenu}>
                  <Text style={styles.txtTitle}>Rút tiền</Text>
                  <Text style={styles.txtMoney}> {toPriceVnd(1000000)} Đ </Text>
                </View>
              </View>
            </View>
            <View style={{height: 0.5, backgroundColor: R.colors.borderGray}} />
            <View style={styles.row}>
              <View style={styles.itemMenu}>
                <Text style={styles.txtTitle}>Hoa hồng</Text>
                <Text style={styles.txtMoney1}>+ {toPriceVnd(1000000)} Đ </Text>
              </View>
              <View
                style={{width: 0.5, backgroundColor: R.colors.borderGray}}
              />
              <View style={styles.itemMenu}>
                <Text style={styles.txtTitle}>Lợi nhuận</Text>
                <Text style={styles.txtMoney1}>
                  {' '}
                  + {toPriceVnd(1000000)} Đ{' '}
                </Text>
              </View>
            </View>
          </View>

          <Footer />
        </ScrollView>
      </View>
    </View>
  );
};

export default HomeView;
const styles = StyleSheet.create({
  body: {
    flex: 1,
    backgroundColor: '#DFE7F5',

    marginTop: 60,
    borderTopLeftRadius: 60,
  },
  containerBody: {
    marginTop: -50,
  },
  containerMenu: {
    height: 160,
    backgroundColor: 'white',
    marginVertical: 10,
    marginHorizontal: 20,
    borderRadius: 10,
    shadowColor: '#000',
    shadowOffset: {
      width: 0,
      height: 1,
    },
    shadowOpacity: 0.25,
    shadowRadius: 2.84,
    elevation: 3,
  },
  row: {
    flexDirection: 'row',
    flex: 1,
  },
  itemMenu: {
    flex: 1,
    justifyContent: 'center',
    alignItems: 'center',
  },
  txtTitle: {
    fontSize: getFontXD(36),
    color: R.colors.txtMain2,
    textTransform: 'uppercase',
  },
  txtMoney: {
    fontSize: getFontXD(42),
    color: R.colors.black,
    marginTop: 5,
  },
  txtMoney1: {
    fontSize: getFontXD(42),
    color: '#2fbd04',
    marginTop: 5,
  },
});
