import React, {useState} from 'react';
import {
  View,
  StyleSheet,
  Text,
  KeyboardAvoidingView,
  Platform,
  TextInput,
  Image,
  TouchableOpacity,
  ImageBackground,
  ScrollView,
} from 'react-native';
import HeaderBack from '../../components/Header/HeaderBack';
import RadioForm, {
  RadioButton,
  RadioButtonInput,
  RadioButtonLabel,
} from 'react-native-simple-radio-button';
import PickerImg from '../../components/Picker/PickerImg';
import {HEIGHTXD, WIDTHXD, getFontXD} from '../../Config/Functions';
import R from '../../assets/R';
import Button from '../../components/Button';

const radio_props = [
  {label: 'Rất kém', value: 0},
  {label: 'Kém', value: 1},
  {label: 'Bình thường', value: 2},
  {label: 'Tốt', value: 3},
  {label: 'Rất tốt', value: 4},
];

const FeedbackView = (props) => {
  const [isSelected, setIsSelected] = useState('');
  const [txtInput, setTxtInput] = useState('');
  const [imageAdd, setImageAdd] = useState([]);

  const onPress = (value) => {
    setIsSelected(value);
    // console.log('hellooo');
  };

  const onClickImages = (images) => {
    // const images = imageAdd.map((e) => e.path);
    setImageAdd(images);
  };

  const onClickClose = (index) => {
    console.log('index---', index);
    const temp = imageAdd.filter((e, i) => {
      if (i != index) return e;
    });
    setImageAdd(temp);
  };

  return (
    <KeyboardAvoidingView
      behavior={Platform.Os === 'ios' ? 'padding' : 'height'}
      style={{flex: 1}}
      keyboardVerticalOffset={-50}>
      <View style={{flex: 1}}>
        <HeaderBack isWhite={true} title={'GỬI FEEDBACK'} />
        <View style={styles.container}>
          <Text style={styles.txt}>Đánh giá dịch vụ của DCV Invest</Text>

          <RadioForm animation={true}>
            {radio_props.map((obj, i) => (
              <RadioButton labelHorizontal={true} key={i}>
                <RadioButtonInput
                  obj={obj}
                  index={i}
                  isSelected={isSelected === i}
                  onPress={onPress}
                  r
                  borderWidth={1}
                  buttonColor={isSelected === i ? '#1473E6' : '#C5C5C5'}
                  buttonSize={10}
                  buttonOuterSize={18}
                  buttonStyle={{marginLeft: 20, marginVertical: 10}}
                />
                <RadioButtonLabel
                  obj={obj}
                  index={i}
                  labelColor={'#001C51'}
                  onPress={onPress}
                  labelStyle={{fontSize: 16, paddingLeft: 16}}
                />
              </RadioButton>
            ))}
          </RadioForm>

          <View style={styles.footer}>
            <TextInput
              style={styles.txtInput}
              placeholderTextColor={R.colors.placeHolder}
              multiline={true}
              placeholder={'Hãy chia sẻ cảm nhận về dịch vụ nhé'}
              onChangeText={(val) => setTxtInput(val)}
            />
            <View
              style={{
                borderWidth: 1,
                borderStyle: 'dashed',
                borderColor: '#CBCBCB',
              }}
            />
            <View style={styles.picker}>
              {imageAdd.length > 0 ? (
                <ScrollView showsHorizontalScrollIndicator={false} horizontal>
                  {imageAdd.map((e, index) => (
                    <View key={index} style={styles.imageButton}>
                      <ImageBackground
                        imageStyle={{
                          width: WIDTHXD(330),
                          height: HEIGHTXD(250),
                        }}
                        style={{
                          width: WIDTHXD(330),
                          height: HEIGHTXD(250),
                        }}
                        source={{uri: e}}>
                        <TouchableOpacity
                          style={{
                            flexDirection: 'row',
                            justifyContent: 'flex-end',
                            marginTop: -10,
                            marginRight: -10,
                          }}
                          onPress={() => onClickClose(index)}>
                          <Image
                            style={{height: 30, width: 30}}
                            source={R.images.iconClose}
                          />
                        </TouchableOpacity>
                      </ImageBackground>
                    </View>
                  ))}
                </ScrollView>
              ) : (
                <PickerImg title="Tải ảnh lên" onClickImage={onClickImages} />
              )}
            </View>
          </View>
        </View>

        <View style={styles.containerBtn}>
          <Button onClick={() => console.log('hello')} title={'Gửi feedback'} />
        </View>
      </View>
    </KeyboardAvoidingView>
  );
};

const styles = StyleSheet.create({
  container: {
    flex: 1,
    paddingHorizontal: 30,
    paddingVertical: 10,
  },
  txt: {
    color: '#929292',
    paddingVertical: 16,
    fontSize: 18,
  },
  footer: {
    marginTop: 10,
    borderRadius: 6,
    borderWidth: 2,
    borderColor: '#CBCBCB',
    // height: 200,
    marginHorizontal: 5,
  },
  txtInput: {
    height: 110,
    margin: 10,
  },
  picker: {
    marginLeft: 10,
    marginBottom: 10,
  },
  imageButton: {
    marginTop: 10,
    marginRight: 20,
  },
  containerBtn: {
    marginBottom: 30,
  },
});

export default FeedbackView;
