import React, {useState} from 'react';
import {View, Text, StyleSheet, FlatList, TouchableOpacity} from 'react-native';

import HeaderSearch from '../../components/Header/HeaderSearch';
import {getFontXD} from '../../Config/Functions';
import Item from './Item';

const Fillters = [
  {
    id: '1',
    name: 'Tất cả',
    value: 'all',
  },
  {
    id: '2',
    name: 'Nạp tiền',
    value: 'deposit',
  },
  {
    id: '3',
    name: 'Rút tiền',
    value: 'withdraw',
  },
  {
    id: '4',
    name: 'Chuyển khoản',
    value: 'exchange',
  },
];

const data = [
  {
    id: '1',
    month: 2,
    day: '20',
    name: 'Nạp tiền',
    money: 10000000,
    note: 'Ghi chú nap tiền để đầu tư',
    status: 1,
    date: '20/02/2021',
  },
  {
    id: '2',
    month: 2,
    day: '20',
    name: 'Nạp tiền',
    money: 2000000,
    note: 'Ghi chú nap tiền để đầu tư',
    status: 1,
    date: '20/02/2021',
  },
  {
    id: '3',
    month: 2,
    day: '20',
    name: 'Nạp tiền',
    money: 3000000,
    note: 'Ghi chú nap tiền để đầu tư',
    status: 1,
    date: '20/02/2021',
  },
  {
    id: '4',
    month: 2,
    day: '20',
    name: 'Nạp tiền',
    money: 4000000,
    note: 'Ghi chú nap tiền để đầu tư',
    status: 1,
    date: '20/02/2021',
  },
  {
    id: '5',
    month: 2,
    day: '20',
    name: 'Nạp tiền',
    money: 9000000,
    note: 'Ghi chú nap tiền để đầu tư',
    status: 1,
    date: '20/02/2021',
  },
];
const ExchangeView = (props) => {
  const [selected, setSelected] = useState('1');

  return (
    <View style={{flex: 1}}>
      <HeaderSearch isWhite={true} title={'Giao dịch'} />
      <View style={styles.headerContainer}>
        <FlatList
          showsHorizontalScrollIndicator={false}
          horizontal
          data={Fillters}
          keyExtractor={(item) => item.id}
          renderItem={({item}) => (
            <TouchableOpacity
              onPress={() => setSelected(item.id)}
              style={[
                styles.itemFillter,
                selected == item.id ? {borderColor: '#1473E6'} : null,
              ]}>
              <Text
                style={[
                  styles.txtFillter,
                  selected == item.id ? {color: '#1473E6'} : {},
                ]}>
                {item.name}
              </Text>
            </TouchableOpacity>
          )}
        />
      </View>
      <View style={{flex: 1}}>
        <FlatList
          keyExtractor={(item) => item.id}
          data={data}
          renderItem={({item}) => <Item item={item} />}
        />
      </View>
    </View>
  );
};

const styles = StyleSheet.create({
  headerContainer: {
    paddingVertical: 10,
    backgroundColor: 'white',
  },
  itemFillter: {
    borderRadius: 10,
    paddingVertical: 5,
    paddingHorizontal: 10,
    borderWidth: 1,
    borderColor: '#929292',
    marginLeft: 15,
    minWidth: 70,
  },
  txtFillter: {
    fontSize: getFontXD(36),
    color: '#929292',
  },
});

export default ExchangeView;
