import React, {useState, useEffect} from 'react';
import {
  View,
  Text,
  StyleSheet,
  Image,
  TouchableOpacity,
  KeyboardAvoidingView,
  Platform,
  Alert,
} from 'react-native';
import InputIcon from '../../components/Input/InputIcon';
import {getFontXD, HEIGHTXD, WIDTHXD} from '../../Config/Functions';
import R from '../../assets/R';
import {useNavigation} from '@react-navigation/native';
import {
  TABNAVIGATOR,
  FORGOTPASSWORD,
  CONFIRMEMAIL,
} from '../../routers/ScreenNames';
import {checkFormatArray} from '../../Config/Functions';
import {loginApi} from '../../apis/Functions/users';
import KEY from '../../assets/AsynStorage';
import AsyncStorage from '@react-native-community/async-storage';
import {showLoading, hideLoading} from '../../actions/loadingAction';
import {saveUserToRedux} from '../../actions/users';
import {connect} from 'react-redux';

const Login = (props) => {
  const {navigation} = props;

  const [email, setEmail] = useState('');
  const [pass, setPass] = useState('');

  const navigate = useNavigation();

  useEffect(() => {
    getAccount();
  }, []);

  const getAccount = async () => {
    const jsonValue = await AsyncStorage.getItem(KEY.ACCOUNT);
    const account = JSON.parse(jsonValue);
    if (account) {
      onSubmitLogin(account.email, account.pass);
    }
  };

  const onSubmitLogin = async (email, pass) => {
    const titles = ['tên đăng nhập', 'mật khẩu'];
    const index = checkFormatArray([email, pass]);

    if (index === true) {
      props.showLoading();
      firebase = await AsyncStorage.getItem(KEY.FIREBASE);
      const res = await loginApi({
        email,
        password: pass,
        platform: Platform.OS,
        device_token: firebase,
        account_type: 'CUSTOMER',
      });

      props.hideLoading();
      if (res.data.code == 200 && res.data.data) {
        const jsonValue = JSON.stringify({email, pass});
        AsyncStorage.setItem(KEY.TOKEN, res.data.data.token);
        AsyncStorage.setItem(KEY.ACCOUNT, jsonValue);
        props.saveUserToRedux(res.data.data);
        navigate.reset({
          index: 1,
          routes: [{name: TABNAVIGATOR}],
        });
      } else {
        setTimeout(() => {
          Alert.alert('Thông báo', res.data.message);
        }, 500);
      }
    } else {
      Alert.alert('Thông báo', 'Vui lòng điền ' + titles[index]);
    }
  };


  
  return (
    <View
      style={{
        flex: 1,
        paddingHorizontal: 20,
        paddingTop: 20,
        backgroundColor: 'white',
      }}>
      <InputIcon
        icon={R.images.iconUser3}
        title={'Tên đăng nhập'}
        placeholder={'Nhập tên đăng nhập'}
        onChangeText={(val) => setEmail(val)}
        value={email}
      />
      <InputIcon
        icon={R.images.iconLock}
        title={'Mật khẩu'}
        placeholder={'Nhập mật khẩu'}
        isPassWord={true}
        onChangeText={(val) => setPass(val)}
        value={pass}
      />
      <TouchableOpacity
        onPress={() => navigate.navigate(CONFIRMEMAIL)}
        style={styles.forgotView}>
        <Text style={styles.txtTitle}>Quên mật khẩu?</Text>
      </TouchableOpacity>

      <View
        style={{
          marginVertical: 20,
          alignItems: 'center',
        }}>
        <TouchableOpacity
          onPress={() => onSubmitLogin(email, pass)}
          style={styles.wrapLogin}>
          <Text style={styles.txtLogin}>Đăng nhập</Text>
          <Image source={R.images.iconRight1} style={styles.imgIcon} />
        </TouchableOpacity>

        <View style={styles.row}>
          <Text style={styles.txtTitle}>Bạn chưa có tài khoản?</Text>
          <TouchableOpacity
            onPress={() => {
              navigation.navigate('REGISTOR');
            }}>
            <Text style={styles.txtRegistor}>Đăng ký</Text>
          </TouchableOpacity>
        </View>
      </View>
      <View style={{height: 100}} />
    </View>
  );
};

const styles = StyleSheet.create({
  forgotView: {
    marginVertical: 20,
    alignItems: 'flex-end',
  },
  txtTitle: {
    fontSize: getFontXD(42),
    color: '#929292',
  },
  txtLogin: {
    fontSize: getFontXD(48),
    color: 'white',
    fontWeight: '700',
  },
  wrapLogin: {
    width: WIDTHXD(512),
    height: HEIGHTXD(150),
    backgroundColor: '#1C6AF6',
    borderRadius: 30,
    flexDirection: 'row',
    justifyContent: 'center',
    alignItems: 'center',
  },
  imgIcon: {
    width: WIDTHXD(72),
    height: HEIGHTXD(72),
    marginLeft: 5,
  },
  row: {
    flexDirection: 'row',
    marginTop: 30,
  },
  txtRegistor: {
    fontSize: getFontXD(42),
    color: '#1473E6',
  },
});

const mapStateToProps = (state) => {
  return {};
};
export default connect(mapStateToProps, {
  showLoading,
  hideLoading,
  saveUserToRedux,
})(Login);
